/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.agent.mqtt.generic.osgi;

import org.eclipse.sensinact.gateway.agent.mqtt.generic.internal.AbstractMqttHandler;
import org.eclipse.sensinact.gateway.agent.mqtt.generic.internal.GenericMqttAgent;
import org.eclipse.sensinact.gateway.common.bundle.AbstractActivator;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMqttActivator
extends AbstractActivator<Mediator> {
    private final Logger LOG = LoggerFactory.getLogger(AbstractMqttActivator.class);
    private AbstractMqttHandler handler;
    private GenericMqttAgent agent;

    protected void doStart(AbstractMqttHandler handler) throws Exception {
        this.LOG.debug("Starting MQTT Agent");
        String broker = this.mediator.getProperty("broker").toString();
        String prefix = this.mediator.getProperty("prefix").toString();
        Object username = this.mediator.getProperty("username");
        Object password = this.mediator.getProperty("password");
        Integer qos = new Integer(this.mediator.getProperty("qos").toString());
        this.LOG.debug("Starting MQTT Agent point to server {} with prefix {} and qos {}", new Object[]{broker, prefix, qos});
        this.handler = handler;
        this.agent = username != null && password != null && !username.toString().trim().equals("") && !password.toString().trim().equals("") ? new GenericMqttAgent(broker, qos, prefix, username.toString(), password.toString()) : new GenericMqttAgent(broker, qos, prefix);
        this.handler.setAgent(this.agent);
        this.mediator.callService(Core.class, (Executable)new Executable<Core, String>(){

            public String execute(Core service) throws Exception {
                return service.registerAgent(AbstractMqttActivator.this.mediator, (MidAgentCallback)AbstractMqttActivator.this.handler, null);
            }
        });
    }

    public void doStop() throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Stopping MQTT agent");
        }
        this.handler.stop();
        this.handler = null;
        this.agent.close();
    }

    public Mediator doInstantiate(BundleContext context) {
        return new Mediator(context);
    }
}

