/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.exporter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.rsa.util.StringPlus;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointListenerNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointListenerNotifier.class);
    private Map<EndpointEventListener, Set<Filter>> listeners = new ConcurrentHashMap<EndpointEventListener, Set<Filter>>();

    public static Set<Filter> filtersFromEL(ServiceReference<EndpointListener> sref) {
        List scopes = StringPlus.normalize((Object)sref.getProperty("endpoint.listener.scope"));
        return EndpointListenerNotifier.getFilterSet(scopes);
    }

    public static Set<Filter> filtersFromEEL(ServiceReference<EndpointEventListener> sref) {
        List scopes = StringPlus.normalize((Object)sref.getProperty("endpoint.listener.scope"));
        return EndpointListenerNotifier.getFilterSet(scopes);
    }

    private static Set<Filter> getFilterSet(List<String> scopes) {
        HashSet<Filter> filters = new HashSet<Filter>();
        for (String scope : scopes) {
            try {
                filters.add(FrameworkUtil.createFilter((String)scope));
            }
            catch (InvalidSyntaxException e) {
                LOG.error("invalid endpoint listener scope: {}", (Object)scope, (Object)e);
            }
        }
        return filters;
    }

    public void add(EndpointEventListener ep, Set<Filter> filters, Collection<EndpointDescription> endpoints) {
        LOG.debug("EndpointListener added");
        this.listeners.put(ep, filters);
        for (EndpointDescription endpoint : endpoints) {
            EndpointEvent event = new EndpointEvent(1, endpoint);
            this.notifyListener(event, ep, filters);
        }
    }

    public void remove(EndpointEventListener ep) {
        LOG.debug("EndpointListener removed");
        this.listeners.remove(ep);
    }

    public void sendEvent(EndpointEvent event) {
        for (EndpointEventListener listener : this.listeners.keySet()) {
            Set<Filter> filters = this.listeners.get(listener);
            this.notifyListener(event, listener, filters);
        }
    }

    private void notifyListener(EndpointEvent event, EndpointEventListener listener, Set<Filter> filters) {
        Set<Filter> matchingFilters = EndpointListenerNotifier.getMatchingFilters(filters, event.getEndpoint());
        for (Filter filter : matchingFilters) {
            listener.endpointChanged(event, filter.toString());
        }
    }

    private static Set<Filter> getMatchingFilters(Set<Filter> filters, EndpointDescription endpoint) {
        HashSet<Filter> matchingFilters = new HashSet<Filter>();
        if (endpoint == null) {
            return matchingFilters;
        }
        Hashtable dict = new Hashtable(endpoint.getProperties());
        for (Filter filter : filters) {
            if (filter.match(dict)) {
                LOG.debug("Filter {} matches endpoint {}", (Object)filter, dict);
                matchingFilters.add(filter);
                continue;
            }
            LOG.trace("Filter {} does not match endpoint {}", (Object)filter, dict);
        }
        return matchingFilters;
    }
}

