/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.topologymanager.importer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.aries.rsa.topologymanager.importer.MultiMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyManagerImport
implements EndpointEventListener,
RemoteServiceAdminListener {
    private static final Logger LOG = LoggerFactory.getLogger(TopologyManagerImport.class);
    private ExecutorService execService;
    private final BundleContext bctx;
    private Set<RemoteServiceAdmin> rsaSet;
    private boolean stopped;
    private final MultiMap<EndpointDescription> importPossibilities = new MultiMap();
    private final MultiMap<ImportRegistration> importedServices = new MultiMap();

    public TopologyManagerImport(BundleContext bc) {
        this.rsaSet = new HashSet<RemoteServiceAdmin>();
        this.bctx = bc;
        this.execService = new ThreadPoolExecutor(5, 10, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public void start() {
        this.stopped = false;
        this.bctx.registerService(RemoteServiceAdminListener.class, (Object)this, null);
    }

    public void stop() {
        this.stopped = true;
        this.execService.shutdown();
        try {
            this.execService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closeAllImports();
    }

    private void closeAllImports() {
        this.importPossibilities.clear();
        for (String filter : this.importedServices.keySet()) {
            this.unImportForGoneEndpoints(filter);
        }
    }

    public void add(RemoteServiceAdmin rsa) {
        this.rsaSet.add(rsa);
        for (String filter : this.importPossibilities.keySet()) {
            this.triggerSynchronizeImports(filter);
        }
    }

    public void remove(RemoteServiceAdmin rsa) {
        this.rsaSet.remove(rsa);
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        if (event.getType() == 4) {
            this.unImport(event.getImportReference());
        }
    }

    private void triggerSynchronizeImports(final String filter) {
        LOG.debug("Import of a service for filter {} was queued", (Object)filter);
        if (!this.rsaSet.isEmpty()) {
            this.execService.execute(new Runnable(){

                @Override
                public void run() {
                    TopologyManagerImport.this.synchronizeImports(filter);
                }
            });
        }
    }

    private void synchronizeImports(String filter) {
        try {
            this.unImportForGoneEndpoints(filter);
            this.importServices(filter);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void importServices(String filter) {
        Set<ImportRegistration> importRegistrations = this.importedServices.get(filter);
        for (EndpointDescription endpoint : this.importPossibilities.get(filter)) {
            ImportRegistration ir;
            if (this.alreadyImported(endpoint, importRegistrations) || (ir = this.importService(endpoint)) == null) continue;
            this.importedServices.put(filter, ir);
        }
    }

    private boolean alreadyImported(EndpointDescription endpoint, Set<ImportRegistration> importRegistrations) {
        for (ImportRegistration ir : importRegistrations) {
            if (!endpoint.equals((Object)ir.getImportReference().getImportedEndpoint())) continue;
            return true;
        }
        return false;
    }

    private ImportRegistration importService(EndpointDescription endpoint) {
        for (RemoteServiceAdmin rsa : this.rsaSet) {
            ImportRegistration ir = rsa.importService(endpoint);
            if (ir == null) continue;
            if (ir.getException() == null) {
                LOG.debug("Service import was successful {}", (Object)ir);
                return ir;
            }
            LOG.info("Error importing service " + endpoint, ir.getException());
        }
        return null;
    }

    private void unImportForGoneEndpoints(String filter) {
        HashSet<ImportRegistration> importRegistrations = new HashSet<ImportRegistration>(this.importedServices.get(filter));
        Set<EndpointDescription> endpoints = this.importPossibilities.get(filter);
        for (ImportRegistration ir : importRegistrations) {
            EndpointDescription endpoint = ir.getImportReference().getImportedEndpoint();
            if (endpoints.contains(endpoint)) continue;
            this.unImport(ir.getImportReference());
        }
    }

    private void unImport(ImportReference ref) {
        ArrayList<ImportRegistration> removed = new ArrayList<ImportRegistration>();
        HashSet<String> imported = new HashSet<String>(this.importedServices.keySet());
        for (String key : imported) {
            for (ImportRegistration ir : this.importedServices.get(key)) {
                if (!ir.getImportReference().equals(ref)) continue;
                removed.add(ir);
            }
        }
        this.closeAll(removed);
    }

    private void closeAll(List<ImportRegistration> removed) {
        for (ImportRegistration ir : removed) {
            this.importedServices.remove(ir);
            ir.close();
        }
    }

    public void endpointChanged(EndpointEvent event, String filter) {
        if (this.stopped) {
            return;
        }
        EndpointDescription endpoint = event.getEndpoint();
        LOG.debug("Endpoint event received type {}, filter {}, endpoint {}", new Object[]{event.getType(), filter, endpoint});
        switch (event.getType()) {
            case 1: {
                this.importPossibilities.put(filter, endpoint);
                break;
            }
            case 2: {
                this.importPossibilities.remove(filter, endpoint);
                break;
            }
            case 4: {
                this.importPossibilities.remove(filter, endpoint);
                this.importPossibilities.put(filter, endpoint);
                break;
            }
            case 8: {
                this.importPossibilities.remove(filter, endpoint);
            }
        }
        this.triggerSynchronizeImports(filter);
    }
}

