/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter
public class CorsFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CorsFilter.class);

    public void init(FilterConfig config) throws ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.info("Init with config [" + config + "]");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (res.isCommitted()) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("OPTIONS".equals(request.getMethod())) {
            ((HttpServletResponse)res).setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
            StringBuilder builder = new StringBuilder();
            String controlRequestHeaders = request.getHeader("Access-Control-Request-Headers");
            if (controlRequestHeaders != null && controlRequestHeaders.length() > 0) {
                builder.append(controlRequestHeaders);
                builder.append(",");
            }
            builder.append("Authorization, X-Auth-Token, X-Requested-With");
            response.setHeader("Access-Control-Allow-Headers", builder.toString());
            ServletOutputStream output = res.getOutputStream();
            output.println();
        } else {
            try {
                chain.doFilter(req, res);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void destroy() {
        if (LOG.isDebugEnabled()) {
            LOG.info("Destroyed filter");
        }
    }
}

