/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.EventListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class WhiteboardListenerHandler
extends ListenerHandler {
    private final BundleContext bundleContext;

    public WhiteboardListenerHandler(long contextServiceId, ExtServletContext context, ListenerInfo listenerInfo, BundleContext bundleContext) {
        super(contextServiceId, context, listenerInfo);
        this.bundleContext = bundleContext;
    }

    @Override
    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        ServiceReference serviceReference = this.getListenerInfo().getServiceReference();
        this.setListener((EventListener)ServiceUtils.safeGetServiceObjects(this.bundleContext, serviceReference));
        int reason = super.init();
        if (reason != -1) {
            ServiceUtils.safeUngetServiceObjects(this.bundleContext, serviceReference, this.getListener());
            this.setListener(null);
        }
        return reason;
    }

    @Override
    public boolean destroy() {
        EventListener l = this.getListener();
        if (l != null && super.destroy()) {
            ServiceUtils.safeUngetServiceObjects(this.bundleContext, this.getListenerInfo().getServiceReference(), l);
            return true;
        }
        return false;
    }
}

