/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.AttributeBuilder;
import org.eclipse.sensinact.gateway.core.MetadataBuilder;
import org.eclipse.sensinact.gateway.core.RequirementBuilder;
import org.eclipse.sensinact.gateway.generic.parser.ConstrainableDefinition;
import org.eclipse.sensinact.gateway.generic.parser.ConstraintDefinition;
import org.eclipse.sensinact.gateway.generic.parser.MetadataDefinition;
import org.eclipse.sensinact.gateway.generic.parser.TargetedResolvedNameTypeValueDefinition;
import org.eclipse.sensinact.gateway.generic.parser.TypeValuePair;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttribute;
import org.eclipse.sensinact.gateway.generic.parser.XmlAttributes;
import org.eclipse.sensinact.gateway.generic.parser.XmlEscaped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

@XmlAttributes(value={@XmlAttribute(attribute="modifiable", field="modifiable"), @XmlAttribute(attribute="hidden", field="hidden"), @XmlAttribute(attribute="observed", field="observed")})
@XmlEscaped(value={"metadata", "constraints"})
public class AttributeDefinition
extends TargetedResolvedNameTypeValueDefinition
implements ConstrainableDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeDefinition.class);
    private List<ConstraintDefinition> constraintDefinitions = new ArrayList<ConstraintDefinition>();
    private List<MetadataBuilder> metadataDefinitions = new ArrayList<MetadataBuilder>();
    protected Modifiable modifiable;
    protected boolean hidden;
    protected boolean observed;

    AttributeDefinition(Mediator mediator, Attributes atts) {
        super(mediator, atts);
    }

    public void setModifiable(String modifiable) {
        if (modifiable == null) {
            return;
        }
        this.modifiable = Modifiable.valueOf((String)modifiable);
    }

    public void setHidden(String hidden) {
        this.hidden = hidden == null ? false : Boolean.parseBoolean(hidden);
    }

    public Modifiable getModifiable() {
        return this.modifiable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void addConstraint(ConstraintDefinition constraint) {
        this.constraintDefinitions.add(constraint);
    }

    public void addMetadataDefinition(MetadataDefinition metadata) {
        this.metadataDefinitions.add(metadata);
    }

    public List<MetadataBuilder> getMetadataBuilders() {
        return Collections.unmodifiableList(this.metadataDefinitions);
    }

    public List<RequirementBuilder> getRequirementBuilders(String service) {
        ArrayList<RequirementBuilder> requirementBuilders = new ArrayList<RequirementBuilder>();
        TypeValuePair nameTypePair = super.getTypeValuePair(service);
        if (nameTypePair != null && nameTypePair.type != null) {
            RequirementBuilder requirementBuilder = null;
            String name = this.getName();
            if (this.modifiable != null) {
                requirementBuilder = new RequirementBuilder(AttributeBuilder.Requirement.MODIFIABLE, name);
                requirementBuilder.put(service, (Object)this.modifiable);
                requirementBuilders.add(requirementBuilder);
            }
            requirementBuilder = new RequirementBuilder(AttributeBuilder.Requirement.HIDDEN, name);
            requirementBuilder.put(service, (Object)this.hidden);
            requirementBuilders.add(requirementBuilder);
            requirementBuilder = new RequirementBuilder(AttributeBuilder.Requirement.TYPE, name);
            requirementBuilder.put(service, nameTypePair.type);
            requirementBuilders.add(requirementBuilder);
            requirementBuilder = new RequirementBuilder(AttributeBuilder.Requirement.VALUE, name);
            requirementBuilder.put(service, nameTypePair.value);
            requirementBuilders.add(requirementBuilder);
        }
        return requirementBuilders;
    }

    public boolean isObserved(String service) {
        if (!this.isTargeted(service)) {
            return false;
        }
        return this.observed;
    }

    public AttributeBuilder getAttributeBuilder(String service) {
        TypeValuePair nameTypePair = this.getTypeValuePair(service);
        if (nameTypePair == null || nameTypePair.type == null) {
            return null;
        }
        AttributeBuilder attributeBuilder = new AttributeBuilder(this.getName(), new AttributeBuilder.Requirement[]{AttributeBuilder.Requirement.TYPE, AttributeBuilder.Requirement.MODIFIABLE, AttributeBuilder.Requirement.HIDDEN});
        attributeBuilder.type(nameTypePair.type);
        if (nameTypePair.value != null) {
            attributeBuilder.value(nameTypePair.value);
        }
        if (this.modifiable != null) {
            attributeBuilder.modifiable(this.modifiable);
        }
        attributeBuilder.hidden(this.hidden);
        List<Constraint> constraints = this.getConstraints(service);
        if (constraints != null) {
            attributeBuilder.addConstraints(constraints);
        }
        attributeBuilder.addMetadataBuilders(this.metadataDefinitions);
        return attributeBuilder;
    }

    public List<Constraint> getConstraints(String service) {
        TypeValuePair nameTypePair = this.getTypeValuePair(service);
        if (nameTypePair == null || nameTypePair.type == null) {
            return Collections.emptyList();
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (ConstraintDefinition definition : this.constraintDefinitions) {
            try {
                constraints.add(definition.getConstraint(nameTypePair.type));
            }
            catch (InvalidConstraintDefinitionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return constraints;
    }

    public void metaStart(Attributes atts) {
        MetadataDefinition metadataDefinition = new MetadataDefinition(this.mediator, atts);
        this.addMetadataDefinition(metadataDefinition);
        super.setNext(metadataDefinition);
    }
}

