/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.simulated.temperature.generator.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.sensinact.gateway.generic.local.LocalProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.parser.DeviceInfo;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.reader.TemperaturesGeneratorPacket;
import org.eclipse.sensinact.gateway.simulated.temperature.generator.thread.TemperaturesGeneratorJob;

public class TemperaturesGeneratorThreadManager {
    private final ScheduledExecutorService worker;
    Map<String, TemperaturesGeneratorJob> jobs = new HashMap<String, TemperaturesGeneratorJob>();

    public TemperaturesGeneratorThreadManager(LocalProtocolStackEndpoint<TemperaturesGeneratorPacket> connector, Set<DeviceInfo> deviceInfos) {
        AtomicInteger counter = new AtomicInteger();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r, "Temperature Generation Thread " + counter.incrementAndGet());
            return t;
        });
        executor.allowCoreThreadTimeOut(false);
        executor.setCorePoolSize(3);
        executor.setMaximumPoolSize(3);
        this.worker = executor;
        for (DeviceInfo deviceInfo : deviceInfos) {
            TemperaturesGeneratorJob job = new TemperaturesGeneratorJob(connector, deviceInfo, this.worker);
            this.jobs.put(deviceInfo.getServiceProviderId(), job);
        }
    }

    public void startThreads() {
        for (TemperaturesGeneratorJob job : this.jobs.values()) {
            this.worker.execute(job);
        }
    }

    public void stopThreads() {
        this.worker.shutdownNow();
        try {
            this.worker.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

