/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.sensinact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.device.openhab.common.Broker;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.DefaultHttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpMediator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContext;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskProcessingContextFactory;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpTask;
import org.osgi.framework.BundleContext;

public class OpenHabMediator
extends HttpMediator {
    private Map<String, Broker> brokerById = new HashMap<String, Broker>();

    public OpenHabMediator(BundleContext context) {
        super(context);
    }

    void addBroker(String id, Broker broker) {
        this.brokerById.put(id, broker);
    }

    public Set<String> removeBroker(String endpointId) {
        return this.brokerById.remove(endpointId).getDevices();
    }

    public List<String> updateBroker(String endpointId, Set<String> devices) {
        Broker broker = this.brokerById.get(endpointId);
        if (broker == null) {
            return Collections.emptyList();
        }
        ArrayList<String> toBeRemoved = new ArrayList<String>(broker.getDevices());
        toBeRemoved.removeAll(devices);
        return toBeRemoved;
    }

    public HttpTaskProcessingContextFactory getTaskProcessingContextFactory() {
        return new DefaultHttpTaskProcessingContextFactory((Mediator)this){

            public HttpTaskProcessingContext newInstance(HttpTaskConfigurator httpTaskConfigurator, String endpointId, HttpTask<?, ?> task) {
                return new OpenHabTaskProcessingContext((Mediator)OpenHabMediator.this, httpTaskConfigurator, endpointId, task);
            }
        };
    }

    class OpenHabTaskProcessingContext
    extends DefaultHttpTaskProcessingContext {
        public OpenHabTaskProcessingContext(Mediator mediator, HttpTaskConfigurator httpTaskConfigurator, final String endpointId, HttpTask<?, ?> task) {
            super(mediator, httpTaskConfigurator, endpointId, task);
            this.properties.put("openhab.scheme", new Executable<Void, String>(){

                public String execute(Void parameter) throws Exception {
                    return ((Broker)OpenHabMediator.this.brokerById.get(endpointId)).getServer().getScheme();
                }
            });
            this.properties.put("openhab.host", new Executable<Void, String>(){

                public String execute(Void parameter) throws Exception {
                    return ((Broker)OpenHabMediator.this.brokerById.get(endpointId)).getServer().getHost();
                }
            });
            this.properties.put("openhab.port", new Executable<Void, String>(){

                public String execute(Void parameter) throws Exception {
                    return Integer.toString(((Broker)OpenHabMediator.this.brokerById.get(endpointId)).getServer().getPort());
                }
            });
        }
    }
}

