/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.test.doGet;
import org.eclipse.sensinact.gateway.sthbnd.http.test.doPost;
import org.eclipse.sensinact.gateway.util.IOUtils;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JettyServerTestCallback {
    private JSONObject remoteEntity;
    private Optional<CountDownLatch> latch = Optional.empty();

    JettyServerTestCallback() {
    }

    @doPost
    public void callbackPost(HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        try {
            byte[] content = IOUtils.read((InputStream)request.getInputStream());
            JSONObject message = new JSONObject(new String(content));
            this.remoteEntity.put("data", message.get("value"));
            response.setStatus(200);
        }
        catch (IOException e) {
            response.setStatus(520);
        }
    }

    @doGet
    public void callbackGet(HttpServletRequest request, HttpServletResponse response) throws IOException, JSONException {
        String uri = request.getRequestURI();
        String[] uriElements = UriUtils.getUriElements((String)uri);
        try {
            PATH path = PATH.valueOf(uriElements[uriElements.length - 1]);
            switch (path) {
                case get: {
                    System.out.println("Call get");
                    response.setContentType("application/json");
                    response.setContentLength(this.remoteEntity.toString().length());
                    if (response.getOutputStream().isReady()) {
                        response.getOutputStream().write(this.remoteEntity.toString().getBytes());
                    }
                    response.setStatus(200);
                    System.err.println("Returning for get: " + this.remoteEntity.toString());
                    this.latch.ifPresent(CountDownLatch::countDown);
                    break;
                }
                case services: {
                    System.out.println("Call services");
                    JSONObject object = new JSONObject();
                    object.put("serviceProviderId", (Object)uriElements[1]);
                    JSONArray services = new JSONArray();
                    services.put((Object)"service1").put((Object)"service2").put((Object)"service3");
                    object.put("services", (Object)services);
                    try {
                        response.setContentType("application/json");
                        response.setContentLength(object.toString().length());
                        if (response.getOutputStream().isReady()) {
                            response.getOutputStream().write(object.toString().getBytes());
                        }
                        response.setStatus(200);
                    }
                    catch (IOException e) {
                        response.setStatus(520);
                    }
                    break;
                }
                case json1: {
                    System.out.println("Call json1");
                    response.setContentType("application/json");
                    JSONObject object = new JSONObject();
                    object.put("serviceProviderId", (Object)this.remoteEntity.getString("serviceProviderId"));
                    response.setContentLength(object.toString().length());
                    if (response.getOutputStream().isReady()) {
                        response.getOutputStream().write(object.toString().getBytes());
                    }
                    response.setStatus(200);
                    break;
                }
                case json2: {
                    System.out.println("Call json2");
                    response.setContentType("text/plain");
                    response.setContentLength(this.remoteEntity.getString("serviceId").length());
                    if (response.getOutputStream().isReady()) {
                        response.getOutputStream().write(this.remoteEntity.getString("serviceId").getBytes());
                    }
                    response.setStatus(200);
                    break;
                }
                case json3: {
                    System.out.println("Call json3");
                    response.setContentType("application/json");
                    JSONArray array = new JSONArray();
                    array.put((Object)this.remoteEntity.getString("resourceId"));
                    array.put(this.remoteEntity.get("data"));
                    response.setContentLength(array.toString().length());
                    if (response.getOutputStream().isReady()) {
                        response.getOutputStream().write(array.toString().getBytes());
                    }
                    response.setStatus(200);
                    break;
                }
            }
        }
        catch (IOException e) {
            response.setStatus(520);
        }
    }

    public void setCountDownLatch(CountDownLatch latch) {
        this.latch = Optional.ofNullable(latch);
    }

    public void setRemoteEntity(JSONObject remoteEntity) {
        System.err.println("Setting entity for: " + remoteEntity.getString("serviceProviderId"));
        this.remoteEntity = remoteEntity;
    }

    private static enum PATH {
        get,
        services,
        json1,
        json2,
        json3;

    }
}

