/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task;

import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.sthbnd.http.SimpleHttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpChainedTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONHttpChainedTask<REQUEST extends Request<SimpleHttpResponse>>
extends HttpChainedTask<REQUEST> {
    private static final Logger LOG = LoggerFactory.getLogger(JSONHttpChainedTask.class);
    protected JSONArray array;
    protected String uri;
    private String chainedIdentifier;

    public JSONHttpChainedTask(Task.CommandType command, TaskTranslator transmitter, Class<REQUEST> requestType, String path, String profileId, ResourceConfig resourceConfig, Object[] parameters) {
        super(command, transmitter, requestType, path, profileId, resourceConfig, parameters);
    }

    public void setChainedIdentifier(String chainedIdentifier) {
        this.chainedIdentifier = chainedIdentifier;
    }

    public String getChainedIdentifier() {
        return this.chainedIdentifier;
    }

    protected void append(Object result) {
        Object append = null;
        if (result == null) {
            return;
        }
        JSONObject object = new JSONObject();
        String chainedIdentifier = this.getChainedIdentifier();
        if (chainedIdentifier == null) {
            chainedIdentifier = Integer.toString(super.hashCode());
        }
        append = byte[].class.isAssignableFrom(result.getClass()) ? new String((byte[])result) : (result == AccessMethod.EMPTY ? new String(new byte[0]) : result);
        Object jsonAppend = null;
        if (String.class == append.getClass()) {
            String appendStr = (String)append;
            try {
                jsonAppend = new JSONObject(appendStr);
            }
            catch (JSONException e) {
                try {
                    jsonAppend = new JSONArray(appendStr);
                }
                catch (JSONException ex) {
                    jsonAppend = appendStr;
                }
            }
        } else {
            jsonAppend = append;
        }
        try {
            object.put(chainedIdentifier, jsonAppend);
        }
        catch (JSONException e) {
            LOG.error("Unable to build the result object");
        }
        this.array.put((Object)object);
    }

    public Void execute(Object result) throws Exception {
        if (result == null || !JSONArray.class.isAssignableFrom(result.getClass())) {
            this.array = new JSONArray();
            this.append(result);
        } else {
            this.array = (JSONArray)result;
        }
        return null;
    }

    public void setResult(Object result, long timestamp) {
        this.append(result);
        super.setResult((Object)this.array, timestamp);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public String toString() {
        return this.uri;
    }

    @Override
    public Map<String, List<String>> getOptions() {
        return super.getHeaders();
    }
}

