/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.interception;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import io.moquette.interception.AbstractInterceptHandler;
import io.moquette.interception.HazelcastMsg;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.moquette.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastInterceptHandler
extends AbstractInterceptHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastInterceptHandler.class);
    private final HazelcastInstance hz;

    public HazelcastInterceptHandler(Server server) {
        this.hz = server.getHazelcastInstance();
    }

    @Override
    public void onPublish(InterceptPublishMessage msg) {
        LOG.info("{} publish on {} message: {}", new Object[]{msg.getClientID(), msg.getTopicName(), new String(msg.getPayload().array())});
        ITopic<HazelcastMsg> topic = this.hz.getTopic("moquette");
        HazelcastMsg hazelcastMsg = new HazelcastMsg(msg);
        topic.publish(hazelcastMsg);
    }
}

