/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.application.feature;

import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.osgitech.rest.runtime.application.AbstractJakartarsProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyExtensionProvider;

public class WhiteboardFeature
implements Feature {
    public static Comparator<Map.Entry<String, JerseyExtensionProvider>> PROVIDER_COMPARATOR = (e1, e2) -> ((JerseyExtensionProvider)e1.getValue()).compareTo((AbstractJakartarsProvider)e2.getValue());
    Map<String, JerseyExtensionProvider> extensions;
    Map<JerseyExtensionProvider, JerseyExtensionProvider.JerseyExtension> extensionInstanceTrackingMap = new HashMap<JerseyExtensionProvider, JerseyExtensionProvider.JerseyExtension>();

    public WhiteboardFeature(Map<String, JerseyExtensionProvider> extensions) {
        this.extensions = extensions.entrySet().stream().sorted(PROVIDER_COMPARATOR).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
    }

    public boolean configure(FeatureContext context) {
        AtomicInteger priority = new AtomicInteger(6000);
        this.extensions.forEach((k, extension) -> {
            JerseyExtensionProvider.JerseyExtension je = extension.getExtension(context);
            if (je != null) {
                this.extensionInstanceTrackingMap.put((JerseyExtensionProvider)extension, je);
                Map<Class<?>, Integer> contractPriorities = je.getContractPriorities();
                if (contractPriorities.isEmpty()) {
                    context.register(je.getExtensionObject(), priority.getAndIncrement());
                } else {
                    context.register(je.getExtensionObject(), je.getContractPriorities());
                }
            }
        });
        return true;
    }

    public void dispose() {
        this.extensionInstanceTrackingMap.forEach((k, v) -> {
            try {
                v.dispose();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        this.extensionInstanceTrackingMap.clear();
        this.extensions.clear();
    }
}

