/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.eclipse.sensinact.gateway.geojson.Coordinates;
import org.eclipse.sensinact.gateway.geojson.Feature;
import org.eclipse.sensinact.gateway.geojson.FeatureCollection;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Geometry;
import org.eclipse.sensinact.gateway.geojson.GeometryCollection;
import org.eclipse.sensinact.gateway.geojson.LineString;
import org.eclipse.sensinact.gateway.geojson.MultiLineString;
import org.eclipse.sensinact.gateway.geojson.MultiPoint;
import org.eclipse.sensinact.gateway.geojson.MultiPolygon;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.gateway.geojson.Polygon;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterBaseVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.ODataFilterParser;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.CommonExprVisitor;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.InvalidResultTypeException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ParsingException;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.ResourceValueFilterInputHolder;
import org.eclipse.sensinact.northbound.filters.sensorthings.antlr.impl.UnsupportedRuleException;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class BooleanMethodCallExprVisitor
extends ODataFilterBaseVisitor<Function<ResourceValueFilterInputHolder, Boolean>> {
    final Parser parser;
    final CommonExprVisitor visitor;

    public BooleanMethodCallExprVisitor(Parser parser) {
        this.parser = parser;
        this.visitor = new CommonExprVisitor(parser);
    }

    @Override
    public Function<ResourceValueFilterInputHolder, Boolean> visitBoolmethodcallexpr(ODataFilterParser.BoolmethodcallexprContext ctx) {
        ParserRuleContext child = (ParserRuleContext)ctx.getChild(ParserRuleContext.class, 0);
        switch (child.getRuleIndex()) {
            case 64: 
            case 65: 
            case 66: {
                return this.runDualString(child);
            }
            case 54: 
            case 61: {
                return this.runGeoRelation(child, (l, r) -> l.relate(r) != SpatialRelation.DISJOINT);
            }
            case 56: {
                return this.runGeoRelation(child, (l, r) -> l.relate(r) == SpatialRelation.DISJOINT);
            }
            case 62: {
                return this.runGeoRelation(child, (l, r) -> l.relate(r) == SpatialRelation.CONTAINS);
            }
            case 58: {
                return this.runGeoRelation(child, (l, r) -> r.relate(l) == SpatialRelation.CONTAINS);
            }
            case 55: {
                return this.runGeoRelation(child, (l, r) -> l.equals(r));
            }
            case 63: {
                return this.runSpatialRelates(child);
            }
            case 57: 
            case 59: 
            case 60: {
                throw new UnsupportedRuleException("Unsupported geometry method", this.parser, child);
            }
        }
        throw new UnsupportedRuleException("Unsupported method call", this.parser, child);
    }

    private <T> T convert(ParserRuleContext ctx, Object object, Class<T> type, boolean allowNull, String placeDescription) {
        if (object == null) {
            if (allowNull) {
                return null;
            }
            throw new InvalidResultTypeException(placeDescription + " is null", type.getSimpleName(), object);
        }
        if (!type.isAssignableFrom(object.getClass())) {
            throw new InvalidResultTypeException("Unsupported " + placeDescription + " for \"" + ctx.getText() + "\"", type.getSimpleName(), object);
        }
        return (T)object;
    }

    private Function<ResourceValueFilterInputHolder, Boolean> runDualString(ParserRuleContext ctx) {
        BiFunction<String, String, Boolean> operation;
        ODataFilterParser.CommonexprContext leftExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        ODataFilterParser.CommonexprContext rightExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 1);
        Object leftFun = this.visitor.visitCommonexpr(leftExpr);
        Object rightFun = this.visitor.visitCommonexpr(rightExpr);
        switch (ctx.getRuleIndex()) {
            case 64: {
                operation = (l, r) -> l.contains((CharSequence)r);
                break;
            }
            case 65: {
                operation = (l, r) -> l.startsWith((String)r);
                break;
            }
            case 66: {
                operation = (l, r) -> l.endsWith((String)r);
                break;
            }
            default: {
                throw new UnsupportedRuleException("Unsupported method call", this.parser, ctx);
            }
        }
        return arg_0 -> this.lambda$runDualString$8(ctx, (Function)leftFun, (Function)rightFun, operation, arg_0);
    }

    private Shape spatialShape(ShapeFactory factory, GeoJsonObject object) {
        switch (object.type) {
            case Feature: {
                return this.spatialShape(factory, ((Feature)object).geometry);
            }
            case FeatureCollection: {
                FeatureCollection collection = (FeatureCollection)object;
                ShapeFactory.MultiShapeBuilder builder = factory.multiShape(Shape.class);
                collection.features.stream().forEachOrdered(f -> builder.add(this.spatialShape(factory, (GeoJsonObject)f)));
                return builder.build();
            }
            case GeometryCollection: {
                GeometryCollection collection = (GeometryCollection)object;
                ShapeFactory.MultiShapeBuilder builder = factory.multiShape(Shape.class);
                collection.geometries.stream().forEachOrdered(g -> builder.add(this.spatialShape(factory, (Geometry)g)));
                return builder.build();
            }
        }
        return this.spatialShape(factory, (Geometry)object);
    }

    private Rectangle tryMakeRectangle(ShapeFactory factory, List<List<Coordinates>> coordinates) {
        if (coordinates.size() != 1) {
            return null;
        }
        List<Coordinates> linearRing = coordinates.get(0);
        if (linearRing.size() != 5) {
            return null;
        }
        HashSet<Double> latitudes = new HashSet<Double>();
        HashSet<Double> longitudes = new HashSet<Double>();
        for (Coordinates c : linearRing) {
            latitudes.add(c.latitude);
            longitudes.add(c.longitude);
        }
        if (latitudes.size() > 2 || longitudes.size() > 2) {
            return null;
        }
        Object[] latArr = latitudes.toArray(new Double[2]);
        Object[] lonArr = longitudes.toArray(new Double[2]);
        Arrays.sort(latArr);
        Arrays.sort(lonArr);
        return factory.rect(((Double)lonArr[0]).doubleValue(), ((Double)lonArr[1]).doubleValue(), ((Double)latArr[0]).doubleValue(), ((Double)latArr[1]).doubleValue());
    }

    private Shape spatialShape(ShapeFactory factory, Geometry geometry) {
        switch (geometry.type) {
            case Point: {
                Coordinates coords = ((Point)geometry).coordinates;
                return factory.pointLatLon(coords.latitude, coords.longitude);
            }
            case LineString: {
                LineString line = (LineString)geometry;
                ShapeFactory.LineStringBuilder builder = factory.lineString();
                line.coordinates.stream().forEachOrdered(c -> builder.pointLatLon(c.latitude, c.longitude));
                return builder.build();
            }
            case Polygon: {
                Polygon polygon = (Polygon)geometry;
                System.out.println("Polygon coord: " + polygon.coordinates);
                Rectangle rect = this.tryMakeRectangle(factory, polygon.coordinates);
                if (rect != null) {
                    return rect;
                }
                ShapeFactory.PolygonBuilder builder = factory.polygon();
                ((List)polygon.coordinates.get(0)).stream().forEachOrdered(c -> builder.pointLatLon(c.latitude, c.longitude));
                return builder.buildOrRect();
            }
            case MultiPoint: {
                MultiPoint points = (MultiPoint)geometry;
                ShapeFactory.MultiPointBuilder builder = factory.multiPoint();
                points.coordinates.stream().forEachOrdered(c -> builder.pointLatLon(c.latitude, c.longitude));
                return builder.build();
            }
            case MultiLineString: {
                MultiLineString lines = (MultiLineString)geometry;
                ShapeFactory.MultiLineStringBuilder builder = factory.multiLineString();
                for (List line : lines.coordinates) {
                    ShapeFactory.LineStringBuilder subBuilder = factory.lineString();
                    line.stream().forEachOrdered(c -> subBuilder.pointLatLon(c.latitude, c.longitude));
                    builder.add(subBuilder);
                }
                return builder.build();
            }
            case MultiPolygon: {
                MultiPolygon polygons = (MultiPolygon)geometry;
                ShapeFactory.MultiShapeBuilder builder = factory.multiShape(Shape.class);
                for (List subPolygon : polygons.coordinates) {
                    Rectangle rect = this.tryMakeRectangle(factory, subPolygon);
                    if (rect != null) {
                        builder.add((Shape)rect);
                        continue;
                    }
                    ShapeFactory.PolygonBuilder initBuilder = factory.polygon();
                    ((List)subPolygon.get(0)).stream().forEachOrdered(c -> initBuilder.pointLatLon(c.latitude, c.longitude));
                    ShapeFactory.PolygonBuilder subBuilder = initBuilder;
                    ArrayList holes = new ArrayList(subPolygon);
                    holes.remove(0);
                    if (!holes.isEmpty()) {
                        for (List hole : holes) {
                            ShapeFactory.PolygonBuilder.HoleBuilder holeBuilder = subBuilder.hole();
                            hole.stream().forEachOrdered(c -> holeBuilder.pointLatLon(c.latitude, c.longitude));
                            subBuilder = holeBuilder.endHole();
                        }
                    }
                    builder.add(subBuilder.build());
                }
                return builder.build();
            }
        }
        throw new ParsingException("Unsupported Geometry: " + geometry.type);
    }

    private Function<ResourceValueFilterInputHolder, Boolean> runGeoRelation(ParserRuleContext ctx, BiFunction<Shape, Shape, Boolean> predicate) {
        SpatialContext spatialContext = SpatialContext.GEO;
        ShapeFactory shpFactory = spatialContext.getShapeFactory();
        ODataFilterParser.CommonexprContext leftExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        ODataFilterParser.CommonexprContext rightExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 1);
        Object leftFun = this.visitor.visitCommonexpr(leftExpr);
        Object rightFun = this.visitor.visitCommonexpr(rightExpr);
        return arg_0 -> this.lambda$runGeoRelation$17(ctx, (Function)leftFun, (Function)rightFun, shpFactory, predicate, arg_0);
    }

    private Function<ResourceValueFilterInputHolder, Boolean> runSpatialRelates(ParserRuleContext ctx) {
        SpatialContext spatialContext = SpatialContext.GEO;
        ShapeFactory shpFactory = spatialContext.getShapeFactory();
        ODataFilterParser.CommonexprContext leftExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 0);
        ODataFilterParser.CommonexprContext rightExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 1);
        ODataFilterParser.CommonexprContext relationExpr = (ODataFilterParser.CommonexprContext)ctx.getChild(ODataFilterParser.CommonexprContext.class, 2);
        Object leftFun = this.visitor.visitCommonexpr(leftExpr);
        Object rightFun = this.visitor.visitCommonexpr(rightExpr);
        Object relationFun = this.visitor.visitCommonexpr(relationExpr);
        return arg_0 -> this.lambda$runSpatialRelates$18(ctx, (Function)leftFun, (Function)rightFun, (Function)relationFun, shpFactory, arg_0);
    }

    private /* synthetic */ Boolean lambda$runSpatialRelates$18(ParserRuleContext ctx, Function leftFun, Function rightFun, Function relationFun, ShapeFactory shpFactory, ResourceValueFilterInputHolder x) {
        Shape rightShape;
        GeoJsonObject left = this.convert(ctx, leftFun.apply(x), GeoJsonObject.class, false, "arg1");
        GeoJsonObject right = this.convert(ctx, rightFun.apply(x), GeoJsonObject.class, false, "arg2");
        String strRelation = this.convert(ctx, relationFun.apply(x), String.class, false, "arg3");
        SpatialRelation relation = SpatialRelation.valueOf((String)strRelation);
        Shape leftShape = this.spatialShape(shpFactory, left);
        return leftShape.relate(rightShape = this.spatialShape(shpFactory, right)) == relation;
    }

    private /* synthetic */ Boolean lambda$runGeoRelation$17(ParserRuleContext ctx, Function leftFun, Function rightFun, ShapeFactory shpFactory, BiFunction predicate, ResourceValueFilterInputHolder x) {
        GeoJsonObject left = this.convert(ctx, leftFun.apply(x), GeoJsonObject.class, false, "arg1");
        GeoJsonObject right = this.convert(ctx, rightFun.apply(x), GeoJsonObject.class, false, "arg2");
        Shape leftShape = this.spatialShape(shpFactory, left);
        Shape rightShape = this.spatialShape(shpFactory, right);
        return (Boolean)predicate.apply(leftShape, rightShape);
    }

    private /* synthetic */ Boolean lambda$runDualString$8(ParserRuleContext ctx, Function leftFun, Function rightFun, BiFunction operation, ResourceValueFilterInputHolder x) {
        String left = this.convert(ctx, leftFun.apply(x), String.class, false, "arg1");
        String right = this.convert(ctx, rightFun.apply(x), String.class, false, "arg2");
        return (Boolean)operation.apply(left, right);
    }
}

