/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.feature.utilities.test;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.eclipse.sensinact.gateway.feature.utilities.test.InputStreamConsumer;

public class ServerProcessHandler {
    private Process process;
    private Thread outputThread;
    private InputStreamConsumer consumer;
    private String configFolder;

    public void startSensinact() throws IOException {
        String javaCmd = ProcessHandle.current().info().command().orElse("java");
        this.process = new ProcessBuilder(javaCmd, "-Dsensinact.config.dir=" + this.getConfigFolder(), "-jar", "target/it/launcher.jar").redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectErrorStream(true).start();
        this.consumer = new InputStreamConsumer(this.process.getInputStream(), true, true);
        this.outputThread = new Thread(this.consumer);
        this.outputThread.start();
    }

    public void setConfigFolder(String folder) {
        this.configFolder = folder;
    }

    private String getConfigFolder() {
        return this.configFolder == null ? "src/it/resources/config" : this.configFolder;
    }

    public boolean isAlive() {
        return this.process != null && this.process.isAlive();
    }

    public Process getProcess() {
        return this.process;
    }

    public InputStreamConsumer getConsumer() {
        return this.consumer;
    }

    public void stopSensinact() {
        this.stopSensinact(false);
    }

    public void stopSensinact(boolean useShell) {
        if (this.process == null) {
            return;
        }
        try {
            if (useShell) {
                try {
                    this.sendCommand("exit 0");
                }
                catch (IOException e) {
                    this.process.destroy();
                }
            } else {
                this.process.destroy();
            }
            this.process.waitFor(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
            }
            this.process = null;
        }
        if (this.outputThread != null) {
            try {
                this.outputThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.outputThread = null;
        }
    }

    public String getOutput() throws IOException {
        return this.getOutput(false);
    }

    public String getOutput(boolean clear) throws IOException {
        if (this.consumer != null) {
            String output = this.consumer.getOutput();
            if (clear) {
                this.consumer.clear();
            }
            return output;
        }
        return null;
    }

    public void write(String data) throws IOException {
        if (this.process == null) {
            throw new IOException("Server is not running");
        }
        OutputStream stream = this.process.getOutputStream();
        stream.write(data.getBytes(StandardCharsets.UTF_8));
        stream.flush();
    }

    public void sendCommand(String command) throws IOException {
        this.write("\n" + command + "\n");
    }
}

