/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.httpwhiteboard;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.eclipse.osgitech.rest.runtime.httpwhiteboard.ServletWhiteboardBasedJerseyServiceRuntime;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.condition.Condition;
import org.osgi.service.servlet.runtime.HttpServiceRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(name="JakartarsServletWhiteboardRuntimeComponent", immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, reference={@Reference(name="runtimeCondition", service=Condition.class, target="(osgi.condition.id=jersey.runtime)")})
public class JakartarsServletWhiteboardRuntimeComponent {
    private static Logger logger = Logger.getLogger(JakartarsServletWhiteboardRuntimeComponent.class.getName());
    private BundleContext context;
    private String target;
    private String basePath;
    private ServiceTracker<HttpServiceRuntime, ServletWhiteboardBasedJerseyServiceRuntime> httpRuntimeTracker;

    @Activate
    public void activate(BundleContext context, Map<String, Object> props) throws ConfigurationException {
        this.context = context;
        this.target = (String)props.get("osgi.http.whiteboard.target");
        this.basePath = (String)props.getOrDefault("jersey.context.path", "/");
        this.openTracker();
    }

    private void openTracker() throws ConfigurationException {
        Filter f;
        try {
            this.target = this.target != null ? String.format("(&(objectClass=org.osgi.service.servlet.runtime.HttpServiceRuntime)%s)", this.target) : "(objectClass=org.osgi.service.servlet.runtime.HttpServiceRuntime)";
            f = this.context.createFilter(this.target);
        }
        catch (InvalidSyntaxException e) {
            throw new ConfigurationException("osgi.http.whiteboard.target", "Invalid target defined: " + this.target, (Throwable)e);
        }
        this.httpRuntimeTracker = new HttpServiceTracker(this.context, f, null);
        this.httpRuntimeTracker.open();
    }

    @Modified
    public void modified(Map<String, Object> props) throws ConfigurationException {
        String oldTarget = this.target;
        String oldBase = this.basePath;
        this.target = (String)props.get("osgi.http.whiteboard.target");
        this.basePath = (String)props.getOrDefault("jersey.context.path", "/");
        if (!Objects.equals(oldTarget, this.target) || !Objects.equals(oldBase, this.basePath)) {
            this.httpRuntimeTracker.close();
            this.openTracker();
        }
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.httpRuntimeTracker.close();
    }

    private final class HttpServiceTracker
    extends ServiceTracker<HttpServiceRuntime, ServletWhiteboardBasedJerseyServiceRuntime> {
        private HttpServiceTracker(BundleContext context, Filter filter, ServiceTrackerCustomizer<HttpServiceRuntime, ServletWhiteboardBasedJerseyServiceRuntime> customizer) {
            super(context, filter, customizer);
        }

        public ServletWhiteboardBasedJerseyServiceRuntime addingService(ServiceReference<HttpServiceRuntime> reference) {
            return new ServletWhiteboardBasedJerseyServiceRuntime(this.context, JakartarsServletWhiteboardRuntimeComponent.this.basePath, reference);
        }

        public void removedService(ServiceReference<HttpServiceRuntime> reference, ServletWhiteboardBasedJerseyServiceRuntime runtime) {
            runtime.teardown(5L, TimeUnit.SECONDS);
        }
    }
}

