/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.application;

import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgitech.rest.dto.DTOConverter;
import org.eclipse.osgitech.rest.helper.JakartarsHelper;
import org.eclipse.osgitech.rest.proxy.ApplicationProxyFactory;
import org.eclipse.osgitech.rest.runtime.application.AbstractJakartarsProvider;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplication;
import org.eclipse.osgitech.rest.runtime.application.JerseyApplicationContentProvider;
import org.glassfish.jersey.server.ResourceConfig;
import org.osgi.service.jakartars.runtime.dto.BaseApplicationDTO;

public class JerseyApplicationProvider
extends AbstractJakartarsProvider<Application> {
    private static final Logger logger = Logger.getLogger("jersey.applicationProvider");
    private boolean locked;
    private List<JerseyApplicationContentProvider> providers = new ArrayList<JerseyApplicationContentProvider>();
    private ResourceConfig config;

    public JerseyApplicationProvider(Application application, Map<String, Object> properties) {
        super(application, properties);
    }

    public String getPath() {
        String base = this.getApplicationBase();
        return JakartarsHelper.getFullApplicationPath((Application)this.getProviderObject(), base == null ? "" : base);
    }

    public ResourceConfig getJakartarsApplication() {
        this.locked = true;
        if (this.config == null) {
            Application application = (Application)this.getProviderObject();
            JerseyApplication jerseyApp = application.getClass().isAnnotationPresent(ApplicationPath.class) ? ApplicationProxyFactory.createDynamicSubclass(this.getApplicationBase(), application, this.getProviderProperties(), this.providers) : new JerseyApplication(this.getProviderName(), application, this.getProviderProperties(), this.providers);
            this.config = ResourceConfig.forApplication((Application)jerseyApp);
            this.config.setApplicationName(this.getName());
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>(this.config.getProperties());
            properties.put("jersey.config.server.resource.validation.ignoreErrors", Boolean.TRUE);
            this.config.setProperties(properties);
        }
        return this.config;
    }

    public BaseApplicationDTO getApplicationDTO() {
        int status = this.getProviderStatus();
        if (status == -1) {
            return DTOConverter.toApplicationDTO(this);
        }
        return DTOConverter.toFailedApplicationDTO(this, status);
    }

    public boolean isDefault() {
        return ".default".equals(this.getName());
    }

    public boolean isShadowDefault() {
        return "/".equals(this.getApplicationBase()) && !this.isDefault();
    }

    public boolean addContent(JerseyApplicationContentProvider provider) {
        if (this.locked) {
            throw new IllegalStateException("The application " + this.getId() + " (" + this.getName() + ") is locked");
        }
        if (provider.isFailed()) {
            logger.log(Level.WARNING, "The resource to add is not valid: " + provider.getProviderStatus());
            return false;
        }
        return this.providers.add(provider);
    }

    public boolean removeContent(JerseyApplicationContentProvider provider) {
        if (this.locked) {
            throw new IllegalStateException("The application " + this.getId() + " (" + this.getName() + ") is locked");
        }
        if (provider == null) {
            logger.log(Level.WARNING, "The resource provider is null. There is nothing to remove.");
            return false;
        }
        return this.providers.remove(provider);
    }

    @Override
    protected String getProviderName() {
        Object name = null;
        Map<String, Object> providerProperties = this.getProviderProperties();
        if (providerProperties != null) {
            String baseProperty = this.getPath();
            name = (String)providerProperties.get("osgi.jakartars.name");
            if (name == null && baseProperty != null) {
                name = "." + baseProperty;
            } else if (name != null && !((String)name).equals(".default") && (((String)name).startsWith(".") || ((String)name).startsWith("osgi"))) {
                this.updateStatus(3);
            }
        }
        return name == null ? this.calculateProviderId() : name;
    }

    @Override
    protected void doValidateProperties(Map<String, Object> properties) {
        String applicationBase = this.getApplicationBase();
        if (applicationBase == null || applicationBase.isEmpty()) {
            this.updateStatus(3);
            return;
        }
    }

    private String getApplicationBase() {
        return (String)this.getProviderProperties().get("osgi.jakartars.application.base");
    }

    public Collection<JerseyApplicationContentProvider> getContentProviders() {
        return List.copyOf(this.providers);
    }

    public boolean isChanged(Application application) {
        return true;
    }

    public JerseyApplicationProvider cleanCopy() {
        return new JerseyApplicationProvider((Application)this.getProviderObject(), this.getProviderProperties());
    }
}

