/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgitech.rest.runtime.common;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsExtension;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsName;
import org.osgi.service.jakartars.whiteboard.propertytypes.JakartarsWhiteboardTarget;

@PreMatching
@Component(name="WebsecurityFilter", scope=ServiceScope.PROTOTYPE, enabled=false)
@JakartarsExtension
@JakartarsName(value="WebsecurityFilter")
@JakartarsWhiteboardTarget(value="(websecurity=false)")
public class WebsecurityFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String HEADER_ORIGIN = "Origin";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    private static final String HEADER_ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String HEADER_ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    private static final String HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private Set<String> allowedOrigins = new HashSet<String>(Collections.singleton("*"));

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String origin = requestContext.getHeaderString(HEADER_ORIGIN);
        if (origin == null) {
            return;
        }
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            this.preFlight(origin, requestContext);
        } else {
            this.checkOrigin(requestContext, origin);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String origin = requestContext.getHeaderString(HEADER_ORIGIN);
        if (origin == null || requestContext.getMethod().equalsIgnoreCase("OPTIONS") || requestContext.getProperty("cors.failure") != null) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        responseContext.getHeaders().putSingle((Object)HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
    }

    private void preFlight(String origin, ContainerRequestContext requestContext) throws IOException {
        String allowHeaders;
        this.checkOrigin(requestContext, origin);
        Response.ResponseBuilder builder = Response.ok();
        builder.header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        builder.header(HEADER_ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        String requestMethods = requestContext.getHeaderString(HEADER_ACCESS_CONTROL_REQUEST_METHOD);
        if (requestMethods != null) {
            builder.header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)requestMethods);
        }
        if ((allowHeaders = requestContext.getHeaderString(HEADER_ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            builder.header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)allowHeaders);
        }
        requestContext.abortWith(builder.build());
    }

    private void checkOrigin(ContainerRequestContext requestContext, String origin) {
        if (!this.allowedOrigins.contains("*") && !this.allowedOrigins.contains(origin)) {
            requestContext.setProperty("cors.failure", (Object)true);
            throw new ForbiddenException("Origin not allowed: " + origin);
        }
    }
}

