/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl.snapshot;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sensinact.core.impl.snapshot.AbstractSnapshot;
import org.eclipse.sensinact.core.impl.snapshot.ServiceSnapshotImpl;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.model.core.provider.Provider;

public class ProviderSnapshotImpl
extends AbstractSnapshot
implements ProviderSnapshot {
    private final List<ServiceSnapshotImpl> services = new ArrayList<ServiceSnapshotImpl>();
    private final String modelPackageUri;
    private final String modelName;
    private Provider modelProvider;

    public ProviderSnapshotImpl(String modelPackageUri, String modelName, Provider provider, Instant snapshotInstant) {
        super(provider.getId(), snapshotInstant);
        this.modelPackageUri = modelPackageUri;
        this.modelName = modelName;
        this.modelProvider = provider;
    }

    public String toString() {
        return String.format("ProviderSnapshot(%s/%s/%s, %s)", this.modelPackageUri, this.modelName, this.getName(), this.getSnapshotTime());
    }

    public String getModelPackageUri() {
        return this.modelPackageUri;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void add(ServiceSnapshotImpl svc) {
        this.services.add(svc);
    }

    public List<ServiceSnapshotImpl> getServices() {
        return this.services;
    }

    public Provider getModelProvider() {
        return this.modelProvider;
    }

    public void filterEmptyServices() {
        List filteredList = this.services.stream().filter(s -> !s.getResources().isEmpty()).collect(Collectors.toList());
        this.services.clear();
        this.services.addAll(filteredList);
    }
}

