/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.subscriptions.Topic;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class H2RetainedRepository
implements IRetainedRepository {
    private final MVMap<Topic, RetainedMessage> queueMap;

    public H2RetainedRepository(MVStore mvStore) {
        this.queueMap = mvStore.openMap("retained_store");
    }

    @Override
    public void cleanRetained(Topic topic) {
        this.queueMap.remove((Object)topic);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg) {
        ByteBuf payload = msg.content();
        byte[] rawPayload = new byte[payload.readableBytes()];
        payload.getBytes(0, rawPayload);
        RetainedMessage toStore = new RetainedMessage(topic, msg.fixedHeader().qosLevel(), rawPayload);
        this.queueMap.put((Object)topic, (Object)toStore);
    }

    @Override
    public boolean isEmpty() {
        return this.queueMap.isEmpty();
    }

    @Override
    public List<RetainedMessage> retainedOnTopic(String topic) {
        Topic searchTopic = new Topic(topic);
        ArrayList<RetainedMessage> matchingMessages = new ArrayList<RetainedMessage>();
        for (Map.Entry entry : this.queueMap.entrySet()) {
            Topic scanTopic = (Topic)entry.getKey();
            if (!scanTopic.match(searchTopic)) continue;
            matchingMessages.add((RetainedMessage)entry.getValue());
        }
        return matchingMessages;
    }
}

