/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sensinact.core.annotation.dto.NullAction;
import org.eclipse.sensinact.core.command.AbstractSensinactCommand;
import org.eclipse.sensinact.core.command.GetLevel;
import org.eclipse.sensinact.core.dto.impl.DataUpdateDto;
import org.eclipse.sensinact.core.emf.model.EMFModel;
import org.eclipse.sensinact.core.emf.model.EMFService;
import org.eclipse.sensinact.core.emf.model.SensinactEMFModelManager;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFDigitalTwin;
import org.eclipse.sensinact.core.emf.twin.SensinactEMFProvider;
import org.eclipse.sensinact.core.model.Resource;
import org.eclipse.sensinact.core.model.SensinactModelManager;
import org.eclipse.sensinact.core.model.ValueType;
import org.eclipse.sensinact.core.push.DataUpdateException;
import org.eclipse.sensinact.core.twin.SensinactDigitalTwin;
import org.eclipse.sensinact.core.twin.SensinactResource;
import org.eclipse.sensinact.core.twin.TimedValue;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

public class SetValueCommand
extends AbstractSensinactCommand<Void> {
    private final DataUpdateDto dataUpdateDto;

    public SetValueCommand(DataUpdateDto dataUpdateDto) {
        this.dataUpdateDto = dataUpdateDto;
    }

    protected Promise<Void> call(SensinactDigitalTwin twin, SensinactModelManager modelMgr, PromiseFactory promiseFactory) {
        return this.doCall((SensinactEMFDigitalTwin)twin, (SensinactEMFModelManager)modelMgr, promiseFactory).recoverWith(p -> promiseFactory.failed((Throwable)new DataUpdateException(this.dataUpdateDto.modelPackageUri, this.dataUpdateDto.model, this.dataUpdateDto.provider, this.dataUpdateDto.service, this.dataUpdateDto.resource, this.dataUpdateDto.originalDto, p.getFailure())));
    }

    private Promise<Void> doCall(SensinactEMFDigitalTwin twin, SensinactEMFModelManager modelMgr, PromiseFactory promiseFactory) {
        String packageUri;
        EClass modelEClass = this.dataUpdateDto.modelEClass;
        String string = packageUri = modelEClass == null ? this.dataUpdateDto.modelPackageUri : modelEClass.getEPackage().getNsURI();
        String mod = modelEClass != null ? modelEClass.getName() : (this.dataUpdateDto.model == null ? this.dataUpdateDto.provider : this.dataUpdateDto.model);
        String provider = this.dataUpdateDto.provider;
        EReference svcReference = this.dataUpdateDto.serviceReference;
        EClass svcEClass = svcReference != null ? svcReference.getEReferenceType() : this.dataUpdateDto.serviceEClass;
        String svc = svcReference != null ? svcReference.getName() : this.dataUpdateDto.service;
        String res = this.dataUpdateDto.resource;
        if (mod == null || provider == null || svc == null || res == null) {
            return promiseFactory.failed((Throwable)new NullPointerException("The provider, service and resource must be non null"));
        }
        SensinactResource resource = twin.getResource(packageUri, mod, provider, svc, res);
        if (resource == null) {
            SensinactEMFProvider sp;
            EMFModel model = null;
            if (modelEClass != null) {
                model = modelMgr.getModel(modelEClass);
            } else {
                model = modelMgr.getModel(packageUri, mod);
                if (model == null) {
                    model = modelMgr.createModel(packageUri, mod).withCreationTime(this.dataUpdateDto.timestamp).build();
                }
                modelEClass = model.getModelEClass();
            }
            EMFService service = (EMFService)model.getServices().get(svc);
            if (service == null) {
                if (ProviderPackage.Literals.DYNAMIC_PROVIDER.isSuperTypeOf(model.getModelEClass())) {
                    service = model.createDynamicService(svc, svcEClass);
                } else if (!model.isFrozen()) {
                    service = (EMFService)model.createService(svc).withCreationTime(this.dataUpdateDto.timestamp).build();
                }
            }
            Resource r = (Resource)service.getResources().get(res);
            if (!model.isFrozen() && r == null) {
                r = (Resource)service.createResource(res).withValueType(ValueType.UPDATABLE).withType(this.dataUpdateDto.type).build();
            }
            if (svcEClass == null) {
                svcEClass = service.getServiceEClass();
            }
            if ((sp = twin.getProvider(packageUri, mod, provider)) == null) {
                sp = twin.createProvider(packageUri, mod, provider, this.dataUpdateDto.timestamp);
            }
            resource = (SensinactResource)sp.getOrCreateService(svc, svcEClass).getResources().get(res);
        }
        if (this.dataUpdateDto.data == null && this.dataUpdateDto.actionOnNull == NullAction.UPDATE_IF_PRESENT) {
            Promise p = resource.getValue(Object.class, GetLevel.WEAK).timeout(0L);
            try {
                Throwable t = p.getFailure();
                if (t != null) {
                    return promiseFactory.failed(t);
                }
                TimedValue value = (TimedValue)p.getValue();
                if (value == null || value.getTimestamp() == null) {
                    return promiseFactory.resolved(null);
                }
            }
            catch (Exception e) {
                return promiseFactory.failed((Throwable)e);
            }
        }
        return resource.setValue(this.dataUpdateDto.data, this.dataUpdateDto.timestamp);
    }
}

