/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.unsafequeues;

import io.moquette.broker.unsafequeues.Segment;
import java.util.Objects;

final class SegmentPointer
implements Comparable<SegmentPointer> {
    private final int idPage;
    private final long offset;

    public SegmentPointer(int idPage, long offset) {
        this.idPage = idPage;
        this.offset = offset;
    }

    public SegmentPointer(Segment segment, long offset) {
        this.idPage = segment.begin.idPage;
        this.offset = offset;
    }

    public SegmentPointer copy() {
        return new SegmentPointer(this.idPage, this.offset);
    }

    @Override
    public int compareTo(SegmentPointer other) {
        if (this.idPage == other.idPage) {
            return Long.compare(this.offset, other.offset);
        }
        return Integer.compare(this.idPage, other.idPage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentPointer that = (SegmentPointer)o;
        return this.idPage == that.idPage && this.offset == that.offset;
    }

    public int hashCode() {
        return Objects.hash(this.idPage, this.offset);
    }

    boolean samePage(SegmentPointer other) {
        return this.idPage == other.idPage;
    }

    SegmentPointer moveForward(long length) {
        return new SegmentPointer(this.idPage, this.offset + length);
    }

    public String toString() {
        return "SegmentPointer{idPage=" + this.idPage + ", offset=" + this.offset + '}';
    }

    public long distance(SegmentPointer other) {
        assert (this.idPage == other.idPage);
        return this.offset - other.offset;
    }

    int offset() {
        return (int)this.offset;
    }

    public SegmentPointer plus(int delta) {
        return this.moveForward(delta);
    }

    int pageId() {
        return this.idPage;
    }
}

