/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.core.impl.snapshot;

import java.time.Instant;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.core.impl.snapshot.AbstractSnapshot;
import org.eclipse.sensinact.core.impl.snapshot.ResourceSnapshotImpl;
import org.eclipse.sensinact.core.impl.snapshot.ServiceSnapshotImpl;
import org.eclipse.sensinact.core.snapshot.ProviderSnapshot;
import org.eclipse.sensinact.model.core.provider.Provider;

public class ProviderSnapshotImpl
extends AbstractSnapshot
implements ProviderSnapshot {
    private final Map<String, ServiceSnapshotImpl> services = new LinkedHashMap<String, ServiceSnapshotImpl>();
    private final String modelPackageUri;
    private final String modelName;
    private Provider modelProvider;

    public ProviderSnapshotImpl(String modelPackageUri, String modelName, Provider provider, Instant snapshotInstant) {
        super(provider.getId(), snapshotInstant);
        this.modelPackageUri = modelPackageUri;
        this.modelName = modelName;
        this.modelProvider = provider;
    }

    public String toString() {
        return String.format("ProviderSnapshot(%s/%s/%s, %s)", this.modelPackageUri, this.modelName, this.getName(), this.getSnapshotTime());
    }

    public String getModelPackageUri() {
        return this.modelPackageUri;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void add(ServiceSnapshotImpl svc) {
        this.services.put(svc.getName(), svc);
    }

    public List<ServiceSnapshotImpl> getServices() {
        return List.copyOf(this.services.values());
    }

    public ServiceSnapshotImpl getService(String name) {
        return this.services.get(name);
    }

    public ResourceSnapshotImpl getResource(String service, String resource) {
        ServiceSnapshotImpl svc = this.services.get(service);
        return svc != null ? svc.getResource(resource) : null;
    }

    public Provider getModelProvider() {
        return this.modelProvider;
    }

    public void filterEmptyServices() {
        Iterator<Map.Entry<String, ServiceSnapshotImpl>> iter = this.services.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ServiceSnapshotImpl> entry = iter.next();
            if (!entry.getValue().getResources().isEmpty()) continue;
            iter.remove();
        }
    }
}

