/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.tinybundles.finder;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.ops4j.pax.tinybundles.finder.ClassDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ClassFinder {
    public Collection<ClassDescriptor> findAllEmbeddedClasses(Class<?> klass) throws IOException {
        String resourcePrefix = klass.getName().replace('.', '/') + "\\$.*";
        return this.findAllEmbeddedClasses(klass, resourcePrefix);
    }

    public Collection<ClassDescriptor> findAnonymousClasses(Class<?> klass) throws IOException {
        String resourcePrefix = klass.getName().replace('.', '/') + "\\$\\d.*";
        return this.findAllEmbeddedClasses(klass, resourcePrefix);
    }

    public Collection<ClassDescriptor> findAllEmbeddedClasses(Class<?> klass, String pattern) throws IOException {
        URL classUrl;
        ClassLoader classLoader = klass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((classUrl = classLoader.getResource(ClassFinder.asResource(klass))).getProtocol().equals("jar")) {
            String jarPath = classUrl.getFile();
            int bang = jarPath.indexOf("!");
            if (bang > -1) {
                jarPath = jarPath.substring(0, bang);
            }
            URL url = new URL("jar:" + jarPath + "!/");
            return this.findEmbeddedClasses(url, pattern);
        }
        if (classUrl.getProtocol().equals("file")) {
            File classFile;
            try {
                classFile = new File(classUrl.toURI());
            }
            catch (URISyntaxException exc) {
                throw new IllegalStateException(exc);
            }
            return this.findEmbeddedClasses(classFile, pattern);
        }
        Bundle bundle = FrameworkUtil.getBundle(klass);
        if (bundle != null) {
            String filePattern;
            String path = klass.getPackage().getName().replace('.', '/');
            Enumeration urls = bundle.findEntries(path, filePattern = klass.getSimpleName() + "$*", false);
            if (urls != null) {
                return this.findEmbeddedClasses(urls, pattern);
            }
            return new ArrayList<ClassDescriptor>();
        }
        throw new IllegalArgumentException("No bundle found for class " + klass + ". Unsupported woven or system package classes");
    }

    public List<ClassDescriptor> findEmbeddedClasses(Enumeration<URL> urls, String pattern) throws MalformedURLException {
        String filePattern = "/" + pattern;
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (!url.getFile().matches(filePattern)) continue;
            ClassDescriptor descriptor = new ClassDescriptor(url.getFile(), url);
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<ClassDescriptor> findEmbeddedClasses(File file, String pattern) throws MalformedURLException {
        File dir = file.getParentFile();
        int slash = pattern.lastIndexOf(47);
        String path = pattern.substring(0, slash + 1);
        String filePattern = pattern.substring(slash + 1);
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
        for (File f : dir.listFiles()) {
            if (!f.getName().matches(filePattern)) continue;
            ClassDescriptor descriptor = new ClassDescriptor(path + f.getName(), f.toURI().toURL());
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public List<ClassDescriptor> findEmbeddedClasses(URL jarUrl, String pattern) throws IOException {
        JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
        JarFile jarFile = connection.getJarFile();
        ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().matches(pattern)) continue;
            String entryUrl = jarUrl.toExternalForm() + entry.getName();
            ClassDescriptor descriptor = new ClassDescriptor(entry.getName(), new URL(entryUrl));
            descriptors.add(descriptor);
        }
        jarFile.close();
        return descriptors;
    }

    public static String asResource(Class<?> klass) {
        String name = klass.getName().replace('.', '/') + ".class";
        return name;
    }
}

