/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.southbound.mqtt.test;

import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.security.IAuthenticator;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessage;
import org.eclipse.sensinact.gateway.southbound.mqtt.api.IMqttMessageListener;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientConfiguration;
import org.eclipse.sensinact.gateway.southbound.mqtt.impl.MqttClientHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttAuthTest {
    private static final String USER = "foo";
    private static final String PASSWORD = "foobar";
    private MqttClient client;
    private final List<MqttClientHandler> handlers = new ArrayList<MqttClientHandler>();
    private Server server;
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @BeforeEach
    void start() throws Exception {
        this.server = new Server();
        MemoryConfig config = new MemoryConfig(new Properties());
        config.setProperty("host", "127.0.0.1");
        config.setProperty("port", "2183");
        config.setProperty("authenticator_class", TestAuth.class.getName());
        config.setProperty("allow_anonymous", "false");
        this.server.startServer((IConfig)config);
        this.client = new MqttClient("tcp://127.0.0.1:2183", MqttClient.generateClientId());
        MqttConnectOptions options = new MqttConnectOptions();
        options.setCleanSession(true);
        options.setUserName(USER);
        options.setPassword(PASSWORD.toCharArray());
        this.client.connect(options);
    }

    @AfterEach
    void stop() throws Exception {
        try {
            this.client.disconnect();
            this.client.close();
            for (MqttClientHandler handler : this.handlers) {
                handler.deactivate();
            }
        }
        finally {
            this.server.stopServer();
        }
    }

    MqttClientHandler setupHandler(String handlerId, String user, String password, String ... topics) throws Exception {
        MqttClientHandler handler = new MqttClientHandler();
        MqttClientConfiguration mock = (MqttClientConfiguration)Mockito.mock(MqttClientConfiguration.class);
        Mockito.when((Object)mock.id()).thenReturn((Object)handlerId);
        Mockito.when((Object)mock.host()).thenReturn((Object)"127.0.0.1");
        Mockito.when((Object)mock.port()).thenReturn((Object)2183);
        Mockito.when((Object)mock.topics()).thenReturn((Object)topics);
        Mockito.when((Object)mock.user()).thenReturn((Object)user);
        Mockito.when((Object)mock._password()).thenReturn((Object)(password != null ? password : null));
        handler.activate(mock);
        return handler;
    }

    @Test
    void testMqttConnect() throws Exception {
        ArrayBlockingQueue messages = new ArrayBlockingQueue(32);
        IMqttMessageListener listener = (handler, topic, msg) -> {
            Assertions.assertEquals((Object)handler, (Object)msg.getHandlerId());
            messages.add(msg);
        };
        String topicNoAuth = "sensinact/mqtt/test1/noauth";
        String topicAuth = "sensinact/mqtt/test1/auth";
        String topicAuthBad = "sensinact/mqtt/test1/auth-bad";
        Assertions.assertThrows(MqttSecurityException.class, () -> this.handlers.add(this.setupHandler("id-noauth", null, null, "sensinact/mqtt/test1/noauth")));
        Assertions.assertThrows(MqttSecurityException.class, () -> this.handlers.add(this.setupHandler("id-auth-bad", USER, "foobartoto", "sensinact/mqtt/test1/auth-bad")));
        this.handlers.add(this.setupHandler("id-auth", USER, PASSWORD, "sensinact/mqtt/test1/auth"));
        for (MqttClientHandler handler2 : this.handlers) {
            handler2.addListener(listener, Map.of("sensinact.mqtt.topics.filters", new String[]{"sensinact/mqtt/test1/+"}));
        }
        String content = "HandlerID";
        for (String topic2 : List.of("sensinact/mqtt/test1/noauth", "sensinact/mqtt/test1/auth-bad", "sensinact/mqtt/test1/auth")) {
            this.client.publish(topic2, content.getBytes(StandardCharsets.UTF_8), 1, false);
        }
        IMqttMessage msg1 = (IMqttMessage)messages.poll(1L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)msg1);
        Assertions.assertEquals((int)0, (int)messages.size());
        Assertions.assertEquals((Object)"id-auth", (Object)msg1.getHandlerId());
        Assertions.assertEquals((Object)"sensinact/mqtt/test1/auth", (Object)msg1.getTopic());
        Assertions.assertEquals((Object)content, (Object)new String(msg1.getPayload(), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)0, (int)messages.size());
    }

    public static class TestAuth
    implements IAuthenticator {
        public boolean checkValid(String clientId, String username, byte[] password) {
            return MqttAuthTest.USER.equals(username) && MqttAuthTest.PASSWORD.equals(new String(password));
        }
    }
}

