/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.logic;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.eclipse.sensinact.gateway.app.api.exception.NotAReadableResourceException;
import org.eclipse.sensinact.gateway.app.api.exception.ResourceNotFoundException;
import org.eclipse.sensinact.gateway.app.api.exception.ServiceNotFoundException;
import org.eclipse.sensinact.gateway.app.api.function.DataItf;
import org.eclipse.sensinact.gateway.app.basic.logic.ConditionFunction;
import org.eclipse.sensinact.gateway.app.manager.json.AppOperator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.BundleContext;

public class SimpleConditionFunction
extends ConditionFunction {
    private final ClassLoader cl;
    private final String function;
    private static final String JSON_SCHEMA = "simple_condition.json";

    public SimpleConditionFunction(ClassLoader cl, String function) {
        this.cl = cl;
        this.function = function;
    }

    public static JSONObject getJSONSchemaFunction(BundleContext context) {
        try {
            return new JSONObject(new JSONTokener((Reader)new InputStreamReader(context.getBundle().getResource("/simple_condition.json").openStream())));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Boolean testCondition(List<DataItf> datas) throws NotAReadableResourceException, ResourceNotFoundException, ServiceNotFoundException {
        DataItf variable = datas.get(0);
        DataItf value = datas.get(1);
        boolean complement = false;
        if (datas.size() > 2) {
            complement = (Boolean)CastUtils.castPrimitive(Boolean.TYPE, (Object)datas.get(2).getValue());
        }
        try {
            Constraint constraint = ConstraintFactory.Loader.load((ClassLoader)this.cl, (String)AppOperator.getOperator((String)this.function), (Class)value.getType(), (Object)value.getValue(), (boolean)complement);
            return constraint.complies(variable.getValue());
        }
        catch (InvalidConstraintDefinitionException e) {
            e.printStackTrace();
            return null;
        }
    }
}

