/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.remote;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidCallbackException;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaUpdateMessageImpl;
import org.eclipse.sensinact.gateway.core.remote.MQTTURLExtract;
import org.eclipse.sensinact.gateway.core.remote.SensinactCoreBaseIface;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttBroker;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensinactCoreBase
implements SensinactCoreBaseIface {
    private static final Logger LOG = LoggerFactory.getLogger(SensinactCoreBase.class);
    private ConfigurationAdmin ca;
    private Core sensinact;
    private Mediator mediator;
    private MqttBroker mb;
    private final String namespace;

    public SensinactCoreBase(Mediator mediator, String namespace) {
        this.mediator = mediator;
        this.namespace = namespace;
        this.ca = (ConfigurationAdmin)this.mediator.getContext().getService(this.mediator.getContext().getServiceReference(ConfigurationAdmin.class));
        this.sensinact = (Core)this.mediator.getContext().getService(this.mediator.getContext().getServiceReference(Core.class));
    }

    public void activate() {
        LOG.info("Activating Sensinact Remote object");
        try {
            Dictionary properties = this.ca.getConfiguration("sensinact").getProperties();
            String brokerAddr = properties.get("broker").toString();
            final String brokerTopicPrefix = properties.get("broker.topic.prefix").toString();
            MQTTURLExtract mqttURL = new MQTTURLExtract(brokerAddr);
            this.mb = new MqttBroker.Builder().host(mqttURL.getHost()).port(mqttURL.getPort().intValue()).protocol(MqttBroker.Protocol.valueOf((String)mqttURL.getProtocol().toUpperCase())).build();
            this.sensinact.registerAgent(this.mediator, (MidAgentCallback)new AbstractMidAgentCallback(){

                public void doHandle(SnaLifecycleMessageImpl message) throws MidCallbackException {
                    this.publicRawMessage((SnaMessage<?>)message);
                }

                public void doHandle(SnaUpdateMessageImpl message) throws MidCallbackException {
                    this.publicRawMessage((SnaMessage<?>)message);
                }

                public boolean propagate() {
                    return false;
                }

                public void stop() {
                }

                private void publicRawMessage(SnaMessage<?> event) {
                    try {
                        String uri = new JSONObject(event.getJSON()).getString("uri");
                        int index = uri.indexOf(58);
                        if (index < 0) {
                            SensinactCoreBase.this.mb.publish(String.format("%s%s", brokerTopicPrefix, SensinactCoreBase.this.namespace), event.getJSON().toString());
                            LOG.debug("Sending from namespace {} the message {}", (Object)SensinactCoreBase.this.namespace, (Object)event.getJSON().toString());
                        } else {
                            LOG.debug("Not propagating message from remote Sensinact instance :\n {} ", (Object)event.getJSON().toString());
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed", (Throwable)e);
                    }
                }
            }, null);
            this.mb.connect();
        }
        catch (IOException e) {
            LOG.error("Failed", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Failed", (Throwable)e);
        }
    }

    public void deactivate() {
        try {
            this.mb.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String namespace() {
        return this.namespace;
    }

    Session getSession(String identifier) {
        Session s = this.sensinact.getRemoteSession(identifier);
        return s;
    }

    public String getAll(String identifier, String filter) {
        return this.getSession(identifier).getAll(filter, null).getJSON();
    }

    public String getProviders(String identifier, String filter) {
        Session session = this.getSession(identifier);
        StringBuilder sb = new StringBuilder();
        Set value = session.serviceProviders(filter);
        for (ServiceProvider sp : value) {
            sb.append(sb.length() > 0 ? Character.valueOf(',') : "");
            sb.append('\"');
            sb.append(sp.getName());
            sb.append('\"');
        }
        return sb.toString();
    }

    public String getServices(String identifier, String serviceProviderId) {
        String value = this.getSession(identifier).getServices(serviceProviderId).getJSON();
        return value;
    }

    public String getService(String identifier, String serviceProviderId, String serviceId) {
        String value = this.getSession(identifier).getService(serviceProviderId, serviceId).getJSON();
        return value;
    }

    public String getResources(String identifier, String serviceProviderId, String serviceId) {
        String value = this.getSession(identifier).getResources(serviceProviderId, serviceId).getJSON();
        return value;
    }

    public String getProvider(String identifier, String serviceProviderId) {
        String value = this.getSession(identifier).getProvider(serviceProviderId).getJSON();
        return value;
    }

    public String getResource(String identifier, String serviceProviderId, String serviceId, String resourceId) {
        String value = this.getSession(identifier).getResource(identifier, serviceProviderId, serviceId, resourceId).getJSON();
        return value.toString();
    }

    public String get(String identifier, String serviceProviderId, String serviceId, String resourceId, String attributeId) {
        String value = this.getSession(identifier).get(serviceProviderId, serviceId, resourceId, attributeId, new Object[0]).getJSON();
        return value;
    }

    public String set(String identifier, String serviceProviderId, String serviceId, String resourceId, String attributeId, String parameter) {
        String resultResponse = this.getSession(identifier).set(serviceProviderId, serviceId, resourceId, attributeId, (Object)parameter, new Object[0]).getJSON();
        return resultResponse;
    }

    public String act(String identifier, String serviceProviderId, String serviceId, String resourceId, String parameters) {
        String resultResponse = this.getSession(identifier).act(serviceProviderId, serviceId, resourceId, this.createObjectArrayParamFromJSON(parameters)).getJSON();
        return resultResponse;
    }

    private Object[] createObjectArrayParamFromJSON(String parameters) {
        JSONArray parameterJSONArray = new JSONArray(parameters);
        Object[] parametersObjectArray = new String[parameterJSONArray.length()];
        Iterator it = parameterJSONArray.iterator();
        for (int x = 0; parameters != null && x < parameters.length() && it.hasNext(); ++x) {
            parametersObjectArray[x] = it.next().toString();
        }
        return parametersObjectArray;
    }

    public boolean isAccessible(String identifier, String serviceProviderId, String serviceId, String resourceId) {
        return this.getSession(identifier).isAccessible(serviceProviderId, serviceId, resourceId);
    }
}

