/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.user.openid;

import java.io.IOException;
import java.security.InvalidKeyException;
import org.eclipse.sensinact.gateway.core.security.AccessToken;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.UserKey;
import org.eclipse.sensinact.gateway.core.security.UserKeyBuilder;
import org.eclipse.sensinact.gateway.core.security.user.openid.JsonWebToken;
import org.eclipse.sensinact.gateway.core.security.user.openid.OpenIdUser;
import org.eclipse.sensinact.gateway.core.security.user.openid.OpenIdUserKeyBuilderConfig;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIdAccessTokenUserKeyBuilder
implements UserKeyBuilder<String, AccessToken> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdAccessTokenUserKeyBuilder.class);
    private OpenIdUserKeyBuilderConfig config;

    public OpenIdAccessTokenUserKeyBuilder(OpenIdUserKeyBuilderConfig config) {
        this.config = config;
    }

    public UserKey buildKey(AccessToken token) throws InvalidKeyException, InvalidCredentialException, DataStoreException {
        OpenIdUser user = null;
        try {
            user = this.getUserInfo(token.getAuthenticationMaterial());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        if (user == null) {
            return null;
        }
        return new UserKey(user.getSensiNactPublicKey());
    }

    private OpenIdUser getUserInfo(String bearer) throws IOException {
        if (!this.config.isConfigured()) {
            return null;
        }
        JsonWebToken jwt = new JsonWebToken(bearer, this.config.getPublicKeys());
        if (!jwt.isValid()) {
            return null;
        }
        ConnectionConfigurationImpl connection = new ConnectionConfigurationImpl();
        connection.setUri(this.config.getUserinfoEP().toURL().toExternalForm());
        connection.queryParameter("client_id", this.config.getClientId());
        connection.addHeader("Authorization", "Bearer " + jwt.token());
        connection.setHttpMethod("GET");
        SimpleRequest req = new SimpleRequest((ConnectionConfiguration)connection);
        SimpleResponse resp = (SimpleResponse)req.send();
        byte[] content = resp.getContent();
        String data = new String(content);
        OpenIdUser user = new OpenIdUser(this.config, data, jwt);
        if (user.isValid()) {
            return user;
        }
        return null;
    }
}

