/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.http.test;

import java.io.IOException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpServiceTestClient {
    public static String newRequest(Mediator mediator, String url, String content, String method, String token) {
        ConnectionConfigurationImpl builder = new ConnectionConfigurationImpl();
        builder.setUri(url);
        builder.setAccept("application/json");
        builder.setConnectTimeout(60000);
        builder.setReadTimeout(60000);
        if (token != null) {
            builder.addHeader("X-Auth-Token", token);
        }
        try {
            if (method.equals("GET")) {
                builder.setHttpMethod("GET");
            } else if (method.equals("POST")) {
                builder.setContentType("application/json");
                builder.setHttpMethod("POST");
                if (content != null && content.length() > 0) {
                    JSONObject jsonData = new JSONObject(content);
                    builder.setContent((Object)jsonData.toString());
                }
            } else {
                return null;
            }
            SimpleRequest request = new SimpleRequest((ConnectionConfiguration)builder);
            SimpleResponse response = (SimpleResponse)request.send();
            byte[] responseContent = response.getContent();
            String contentStr = responseContent == null ? null : new String(responseContent);
            return contentStr;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

