/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.test;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.Describable;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.ServiceProvider;
import org.eclipse.sensinact.gateway.core.security.AccessToken;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.http.test.HttpServiceTestClient;
import org.eclipse.sensinact.gateway.core.security.ws.test.WsServiceTestClient;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfiguration;
import org.eclipse.sensinact.gateway.protocol.http.client.ConnectionConfigurationImpl;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleRequest;
import org.eclipse.sensinact.gateway.protocol.http.client.SimpleResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extensions;
import org.osgi.framework.BundleContext;
import org.osgi.test.common.annotation.InjectBundleContext;
import org.osgi.test.common.annotation.InjectService;
import org.osgi.test.junit5.context.BundleContextExtension;
import org.osgi.test.junit5.context.InstalledBundleExtension;
import org.osgi.test.junit5.service.ServiceExtension;

@Extensions(value={@ExtendWith(value={BundleContextExtension.class}), @ExtendWith(value={InstalledBundleExtension.class}), @ExtendWith(value={ServiceExtension.class})})
public class TestThirdPartyAccessToken {
    private static final String SLIDERS_DEFAULT = "[\"slider01\",\"slider02\",\"slider11\"]";
    private static final String SLIDERS_PROP = "org.eclipse.sensinact.simulated.sliders";
    private static final String GUI_ENABLED = "org.eclipse.sensinact.simulated.gui.enabled";
    protected static final String HTTP_ROOTURL = "http://127.0.0.1:8899/sensinact";
    protected static final String WS_ROOTURL = "/sensinact";
    Method getDescription = Describable.class.getDeclaredMethod("getDescription", new Class[0]);

    public boolean isExcluded(String fileName) {
        switch (fileName) {
            case "org.apache.felix.framework.security.jar": {
                return true;
            }
        }
        return false;
    }

    protected void doInit(Map<String, Comparable<?>> configuration) {
        configuration.put("org.osgi.framework.system.packages.extra", (Comparable<?>)((Object)"org.eclipse.sensinact.gateway.test,com.sun.net.httpserver,javax.mail,javax.mail.internet,javax.microedition.io,javax.management.modelmbean,javax.management.remote,javax.persistence,junit.framework,junit.textui,org.w3c.dom,org.xml.sax,org.xml.sax.helpers,sun.misc,sun.security.action"));
        configuration.put(GUI_ENABLED, (Comparable<?>)((Object)"false"));
        configuration.put("org.eclipse.sensinact.gateway.security.jks.filename", (Comparable<?>)((Object)"target/felix/bundle/keystore.jks"));
        configuration.put("org.eclipse.sensinact.gateway.security.jks.password", (Comparable<?>)((Object)"sensiNact_team"));
        configuration.put("org.eclipse.sensinact.gateway.security.database", (Comparable<?>)((Object)new File("../sensinact-security-core/src/test/resources/sensinact.sqlite").getAbsolutePath()));
        configuration.put("felix.auto.start.1", (Comparable<?>)((Object)"file:target/felix/bundle/org.osgi.service.component.jar file:target/felix/bundle/org.osgi.service.cm.jar file:target/felix/bundle/org.osgi.service.metatype.jar file:target/felix/bundle/org.osgi.namespace.extender.jar file:target/felix/bundle/org.osgi.util.promise.jar file:target/felix/bundle/org.osgi.util.function.jar file:target/felix/bundle/org.osgi.util.pushstream.jar file:target/felix/bundle/org.osgi.service.log.jar file:target/felix/bundle/org.apache.felix.log.jar file:target/felix/bundle/org.apache.felix.scr.jar file:target/felix/bundle/org.apache.felix.fileinstall.jar file:target/felix/bundle/org.apache.felix.configadmin.jar file:target/felix/bundle/org.apache.felix.framework.security.jar "));
        configuration.put("felix.auto.install.2", (Comparable<?>)((Object)"file:target/felix/bundle/slf4j-api.jar file:target/felix/bundle/http.jar file:target/felix/bundle/jackson-databind.jar file:target/felix/bundle/jackson-annotations.jar file:target/felix/bundle/jackson-core.jar file:target/felix/bundle/sensinact-utils.jar file:target/felix/bundle/sensinact-datastore-api.jar file:target/felix/bundle/sensinact-sqlite-connector.jar file:target/felix/bundle/sensinact-common.jar file:target/felix/bundle/sensinact-framework-extension.jar file:target/felix/bundle/sensinact-northbound-access.jar file:target/felix/bundle/sensinact-security-openid-keybuilder.jar file:target/felix/bundle/sensinact-security-core.jar file:target/felix/bundle/org.apache.felix.http.servlet-api.jar file:target/felix/bundle/org.apache.felix.http.api.jar file:target/felix/bundle/org.apache.aries.javax.jax.rs-api.jar file:target/felix/bundle/slf4j-simple.jar"));
        configuration.put("felix.auto.start.2", (Comparable<?>)((Object)"file:target/felix/bundle/sensinact-test-configuration.jar file:target/felix/bundle/sensinact-signature-validator.jar file:target/felix/bundle/org.apache.felix.http.jetty.jar "));
        configuration.put("felix.auto.start.3", (Comparable<?>)((Object)"file:target/felix/bundle/sensinact-core.jar file:target/felix/bundle/sensinact-generic.jar file:target/felix/bundle/rest-access.jar "));
        configuration.put("felix.auto.start.4", (Comparable<?>)((Object)"file:target/felix/bundle/slider.jar "));
        configuration.put(SLIDERS_PROP, (Comparable<?>)((Object)SLIDERS_DEFAULT));
        configuration.put("org.osgi.service.http.port", (Comparable<?>)((Object)"8899"));
        configuration.put("org.apache.felix.http.jettyEnabled", Boolean.valueOf(true));
        configuration.put("org.apache.felix.http.whiteboardEnabled", Boolean.valueOf(true));
        configuration.put("org.eclipse.sensinact.security.keybuilder.openid.discoveryURL", (Comparable<?>)((Object)"http://localhost:24680/auth/realms/test/.well-known/openid-configuration"));
        configuration.put("org.eclipse.sensinact.security.keybuilder.openid.client_id", (Comparable<?>)((Object)"testClient"));
        configuration.put("org.eclipse.sensinact.security.keybuilder.openid.client_secret", (Comparable<?>)((Object)"testClient"));
        configuration.put("felix.log.level", (Comparable<?>)((Object)"4"));
    }

    @Disabled
    @Test
    public void testThirdPartyIdentityProvider(@InjectService Core core) throws Throwable {
        while (!this.keycloakAvailable()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(20000L);
        AnonymousSession session = core.getAnonymousSession();
        Assertions.assertNotNull((Object)session);
        Set providers = session.serviceProviders();
        System.out.println(providers);
        Assertions.assertTrue((boolean)providers.isEmpty());
        String token = this.openIdAuthenticate("cea", "sensiNact_team");
        AccessToken credentials = new AccessToken(token);
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)3, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)2, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
        token = this.openIdAuthenticate("fake", "fake");
        credentials = new AccessToken(token);
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)2, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)1, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
        token = this.openIdAuthenticate("fake2", "fake2");
        credentials = new AccessToken(token);
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)1, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)1, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
    }

    @Disabled
    @Test
    public void testThirdPartyIdentityProviderWithCredentials(@InjectService Core core) throws Throwable {
        while (!this.keycloakAvailable()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(20000L);
        AnonymousSession session = core.getAnonymousSession();
        Assertions.assertNotNull((Object)session);
        Set providers = session.serviceProviders();
        System.out.println(providers);
        Assertions.assertTrue((boolean)providers.isEmpty());
        Credentials credentials = new Credentials("cea", "sensiNact_team");
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)3, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)2, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
        credentials = new Credentials("fake", "fake");
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)2, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)1, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
        credentials = new Credentials("fake2", "fake2");
        session = core.getSession((Authentication)credentials);
        Assertions.assertNotNull((Object)session);
        providers = session.serviceProviders();
        Assertions.assertEquals((int)1, (int)providers.size());
        for (ServiceProvider serviceProvider : providers) {
            Assertions.assertEquals((int)1, (int)serviceProvider.getServices().size());
            System.out.println(serviceProvider.getDescription().getJSON());
        }
    }

    @Disabled
    @Test
    public void testSecurityPatternWithHttpNorthbound(@InjectBundleContext BundleContext context) throws Throwable {
        ServicesList services;
        while (!this.keycloakAvailable()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(20000L);
        Mediator mediator = new Mediator(context);
        String response = HttpServiceTestClient.newRequest(mediator, "http://localhost:8899/sensinact/providers", null, "GET", null);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        System.out.println("====================================>>>>>");
        ObjectMapper mapper = new ObjectMapper();
        ProvidersList providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertTrue((boolean)providers.getProviders().isEmpty());
        String sessionToken = this.snaHttpAuthenticate("cea", "sensiNact_team");
        response = HttpServiceTestClient.newRequest(mediator, "http://localhost:8899/sensinact/providers", null, "GET", sessionToken);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertEquals((int)3, (int)providers.getProviders().size());
        for (String provider : providers.getProviders()) {
            response = HttpServiceTestClient.newRequest(mediator, String.format("http://localhost:8899/sensinact/providers/%s/services", provider), null, "GET", sessionToken);
            System.out.println("\t" + response);
            services = (ServicesList)mapper.readValue(response, ServicesList.class);
            Assertions.assertEquals((int)2, (int)services.getServices().size());
        }
        System.out.println("====================================>>>>>");
        sessionToken = this.snaHttpAuthenticate("fake", "fake");
        response = HttpServiceTestClient.newRequest(mediator, "http://localhost:8899/sensinact/providers", null, "GET", sessionToken);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertEquals((int)2, (int)providers.getProviders().size());
        for (String provider : providers.getProviders()) {
            response = HttpServiceTestClient.newRequest(mediator, String.format("http://localhost:8899/sensinact/providers/%s/services", provider), null, "GET", sessionToken);
            System.out.println("\t" + response);
            services = (ServicesList)mapper.readValue(response, ServicesList.class);
            Assertions.assertEquals((int)1, (int)services.getServices().size());
        }
        System.out.println("====================================>>>>>");
        sessionToken = this.snaHttpAuthenticate("fake2", "fake2");
        response = HttpServiceTestClient.newRequest(mediator, "http://localhost:8899/sensinact/providers", null, "GET", sessionToken);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        mapper = new ObjectMapper();
        providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertEquals((int)1, (int)providers.getProviders().size());
        for (String provider : providers.getProviders()) {
            response = HttpServiceTestClient.newRequest(mediator, String.format("http://localhost:8899/sensinact/providers/%s/services", provider), null, "GET", sessionToken);
            System.out.println("\t" + response);
            mapper = new ObjectMapper();
            services = (ServicesList)mapper.readValue(response, ServicesList.class);
            Assertions.assertEquals((int)1, (int)services.getServices().size());
        }
        System.out.println("====================================>>>>>");
    }

    @Disabled
    @Test
    public void testSecurityPatternWithWsNorthbound(@InjectBundleContext BundleContext context) throws Throwable {
        ServicesList services;
        while (!this.keycloakAvailable()) {
            Thread.sleep(1000L);
        }
        Thread.sleep(20000L);
        Mediator mediator = new Mediator(context);
        WsServiceTestClient client = new WsServiceTestClient(null);
        new Thread(client).start();
        String response = this.synchronizedRequest(client, "/sensinact/providers", null);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        System.out.println("====================================>>>>>");
        ObjectMapper mapper = new ObjectMapper();
        ProvidersList providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertTrue((boolean)providers.getProviders().isEmpty());
        client = this.snaWsAuthenticate("cea", "sensiNact_team");
        new Thread(client).start();
        response = this.synchronizedRequest(client, "/sensinact/providers", null);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertEquals((int)3, (int)providers.getProviders().size());
        for (String provider : providers.getProviders()) {
            response = this.synchronizedRequest(client, String.format("/sensinact/providers/%s/services", provider), null);
            System.out.println("\t" + response);
            services = (ServicesList)mapper.readValue(response, ServicesList.class);
            Assertions.assertEquals((int)2, (int)services.getServices().size());
        }
        System.out.println("====================================>>>>>");
        client = this.snaWsAuthenticate("fake", "fake");
        new Thread(client).start();
        response = this.synchronizedRequest(client, "/sensinact/providers", null);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertEquals((int)2, (int)providers.getProviders().size());
        for (String provider : providers.getProviders()) {
            response = this.synchronizedRequest(client, String.format("/sensinact/providers/%s/services", provider), null);
            System.out.println("\t" + response);
            services = (ServicesList)mapper.readValue(response, ServicesList.class);
            Assertions.assertEquals((int)1, (int)services.getServices().size());
        }
        System.out.println("====================================>>>>>");
        client = this.snaWsAuthenticate("fake2", "fake2");
        new Thread(client).start();
        response = this.synchronizedRequest(client, "/sensinact/providers", null);
        System.out.println("====================================>>>>>");
        System.out.println(response);
        mapper = new ObjectMapper();
        providers = (ProvidersList)mapper.readValue(response, ProvidersList.class);
        Assertions.assertEquals((int)1, (int)providers.getProviders().size());
        for (String provider : providers.getProviders()) {
            response = this.synchronizedRequest(client, String.format("/sensinact/providers/%s/services", provider), null);
            System.out.println("\t" + response);
            services = (ServicesList)mapper.readValue(response, ServicesList.class);
            Assertions.assertEquals((int)1, (int)services.getServices().size());
        }
        System.out.println("====================================>>>>>");
    }

    private String synchronizedRequest(WsServiceTestClient client, String url, String content) {
        String simulated = null;
        long wait = 10000L;
        client.newRequest(url, content);
        while (!client.isAvailable() && wait > 0L) {
            wait -= 100L;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        if (client.isAvailable()) {
            simulated = client.getResponseMessage();
        }
        return simulated;
    }

    private boolean keycloakAvailable() {
        try {
            ConnectionConfigurationImpl connection = new ConnectionConfigurationImpl();
            connection.setUri("http://localhost:24680/auth/realms/test/.well-known/openid-configuration");
            connection.setHttpMethod("GET");
            SimpleRequest req = new SimpleRequest((ConnectionConfiguration)connection);
            SimpleResponse resp = (SimpleResponse)req.send();
            return resp.getStatusCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String openIdAuthenticate(String username, String password) throws IOException {
        String credentials = new String("testClient:testClient");
        String basic = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        StringBuilder urlParameters = new StringBuilder();
        urlParameters.append("client_id=testClient");
        urlParameters.append("&username=");
        urlParameters.append(username);
        urlParameters.append("&password=");
        urlParameters.append(password);
        urlParameters.append("&scope=openid%20roles");
        urlParameters.append("&grant_type=password");
        urlParameters.append("&response_type=id_token%20token");
        ConnectionConfigurationImpl connection = new ConnectionConfigurationImpl();
        connection.setUri("http://localhost:24680/auth/realms/test/protocol/openid-connect/token");
        connection.setContentType("application/x-www-form-urlencoded");
        connection.addHeader("Authorization", "Basic " + basic);
        connection.setContent((Object)urlParameters.toString());
        connection.setHttpMethod("POST");
        SimpleRequest req = new SimpleRequest((ConnectionConfiguration)connection);
        SimpleResponse resp = (SimpleResponse)req.send();
        String response = new String(resp.getContent());
        ObjectMapper mapper = new ObjectMapper();
        OpenIdAcessToken token = (OpenIdAcessToken)mapper.readValue(response, OpenIdAcessToken.class);
        return token.getAccessToken();
    }

    private String snaHttpAuthenticate(String username, String password) throws IOException {
        String token = this.openIdAuthenticate(username, password);
        ConnectionConfigurationImpl connection = new ConnectionConfigurationImpl();
        connection.setUri("http://localhost:8899/sensinact.login");
        connection.setAccept("application/json");
        connection.addHeader("Authorization", "Bearer " + token);
        connection.setHttpMethod("GET");
        SimpleRequest req = new SimpleRequest((ConnectionConfiguration)connection);
        SimpleResponse resp = (SimpleResponse)req.send();
        String response = new String(resp.getContent());
        ObjectMapper mapper = new ObjectMapper();
        LoginResponse loginResponse = (LoginResponse)mapper.readValue(response, LoginResponse.class);
        return loginResponse.getToken();
    }

    private WsServiceTestClient snaWsAuthenticate(String username, String password) throws IOException {
        String token = this.openIdAuthenticate(username, password);
        WsServiceTestClient client = new WsServiceTestClient("Bearer " + token);
        return client;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LoginResponse {
        @JsonProperty(value="validUntil")
        private long validUntil;
        @JsonProperty(value="generated")
        private long generated;
        @JsonProperty(value="token")
        private String token;

        public LoginResponse() {
        }

        public LoginResponse(long validUntil, long generated, String token) {
            this.validUntil = validUntil;
            this.generated = generated;
            this.token = token;
        }

        public long getValidUntil() {
            return this.validUntil;
        }

        public void setValidUntil(long validUntil) {
            this.validUntil = validUntil;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public long getGenerated() {
            return this.generated;
        }

        public void setGenerated(long generated) {
            this.generated = generated;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ServicesList {
        @JsonProperty(value="statusCode")
        private int statusCode;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="services")
        private List<String> services;

        public ServicesList() {
        }

        public ServicesList(int statusCode, String type, String uri, List<String> services) {
            this.statusCode = statusCode;
            this.type = type;
            this.uri = uri;
            this.services = services != null ? new ArrayList<String>(services) : Collections.emptyList();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public List<String> getServices() {
            return this.services;
        }

        public void setProviders(List<String> services) {
            this.services = services;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProvidersList {
        @JsonProperty(value="statusCode")
        private int statusCode;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="providers")
        private List<String> providers;

        public ProvidersList() {
        }

        public ProvidersList(int statusCode, String type, String uri, List<String> providers) {
            this.statusCode = statusCode;
            this.type = type;
            this.uri = uri;
            this.providers = providers != null ? new ArrayList<String>(providers) : Collections.emptyList();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public List<String> getProviders() {
            return this.providers;
        }

        public void setProviders(List<String> providers) {
            this.providers = providers;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OpenIdAcessToken {
        @JsonProperty(value="access_token")
        private String accessToken;
        @JsonProperty(value="id_token")
        private String idToken;
        @JsonProperty(value="refresh_token")
        private String refreshToken;
        @JsonProperty(value="expires_in")
        private Integer expiresIn;

        public OpenIdAcessToken() {
        }

        public OpenIdAcessToken(String accessToken, String idToken) {
            this.accessToken = accessToken;
            this.idToken = idToken;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public Integer getExpiresIn() {
            return this.expiresIn;
        }

        public void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }
    }
}

