/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.ws.test;

import java.net.URI;
import java.util.Stack;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.json.JSONArray;
import org.json.JSONObject;

@WebSocket(maxTextMessageSize=65536)
public class WsServiceTestClient
implements Runnable {
    String destUri = "ws://localhost:8899/ws/sensinact";
    WebSocketClient client = null;
    Session session;
    AtomicBoolean available;
    private String lastMessage;
    private boolean running = false;
    private Stack<WsRequest> stack = new Stack();

    public WsServiceTestClient(String authorization) {
        this.available = new AtomicBoolean(false);
        try {
            ClientUpgradeRequest req;
            this.client = new WebSocketClient();
            this.client.setMaxIdleTimeout(3600000L);
            this.client.start();
            URI echoUri = new URI(this.destUri);
            if (authorization != null) {
                req = new ClientUpgradeRequest();
                req.setHeader("Authorization", authorization);
                req.setLocalEndpoint((Object)this);
                req.setRequestURI(echoUri);
            } else {
                req = null;
            }
            Future future = req != null ? this.client.connect((Object)this, echoUri, req) : this.client.connect((Object)this, echoUri);
            future.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            t.printStackTrace();
            try {
                this.client.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAvailable(boolean available) {
        this.available.set(available);
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    public String getResponseMessage() {
        return this.lastMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newRequest(String url, String content) {
        this.setAvailable(false);
        this.lastMessage = null;
        Stack<WsRequest> stack = this.stack;
        synchronized (stack) {
            this.stack.push(new WsRequest(url, content));
        }
    }

    protected void send(String message) {
        if (this.session == null) {
            throw new NullPointerException("Null webSocket session");
        }
        try {
            Future future = this.session.getRemote().sendStringByFuture(message);
            future.get(1L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.session = null;
        this.close();
    }

    public void close() {
        this.running = false;
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        this.setAvailable(true);
        this.lastMessage = message;
    }

    @OnWebSocketError
    public void handleError(Throwable error) {
        error.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        boolean locked = true;
        WsRequest request = null;
        while (this.running || locked) {
            request = null;
            Stack<WsRequest> stack = this.stack;
            synchronized (stack) {
                if (!this.stack.isEmpty()) {
                    request = this.stack.pop();
                }
                locked = !this.stack.isEmpty();
            }
            if (request != null) {
                JSONObject json = new JSONObject();
                json.put("uri", (Object)request.url);
                if (request.content != null) {
                    json.put("parameters", (Object)new JSONArray(request.content));
                }
                try {
                    this.send(json.toString());
                    continue;
                }
                catch (NullPointerException e) {
                    Stack<WsRequest> stack2 = this.stack;
                    synchronized (stack2) {
                        this.stack.push(request);
                        continue;
                    }
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                break;
            }
        }
        try {
            this.client.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class WsRequest {
        public final String url;
        public final String content;

        WsRequest(String url, String content) {
            this.url = url;
            this.content = content;
        }
    }
}

