/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CastUtils {
    private static final Logger LOGGER = Logger.getLogger(CastUtils.class.getCanonicalName());
    public static final String SPACE_DELIMITER = " ";
    public static final String COMMA_DELIMITER = ",";
    public static final String SEMICOLON_DELIMITER = ";";
    private static final List<Class<?>> PRIMITIVE_AND_WRAPPERS = new ArrayList();
    public static final String ARRAY_OF_PREFIX = "Array of ";

    public static boolean isPrimitive(Class<?> clazz) {
        return PRIMITIVE_AND_WRAPPERS.contains(clazz);
    }

    public static boolean isAssignableFrom(Class<?> clazz1, Class<?> clazz2) {
        if (!clazz1.isAssignableFrom(clazz2)) {
            Class<?> wrapperclazz = CastUtils.getWrapperClass(clazz1);
            Class<?> wrapperClass2 = CastUtils.getWrapperClass(clazz2);
            return wrapperclazz != null && wrapperClass2 != null && wrapperclazz.isAssignableFrom(wrapperClass2);
        }
        return true;
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (!CastUtils.isPrimitive(clazz) || clazz == String.class) {
            return null;
        }
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static Class<?> loadClass(ClassLoader classloader, String type) throws ClassNotFoundException {
        if (type == null || classloader == null) {
            return null;
        }
        Class<?> clazz = null;
        boolean arrayType = type.startsWith(ARRAY_OF_PREFIX);
        String rawType = (arrayType ? type.substring(ARRAY_OF_PREFIX.length()) : type).trim();
        Class<?> rawClass = CastUtils.jsonTypeToJavaType(rawType);
        if (rawClass == null) {
            rawClass = classloader.loadClass(rawType);
        }
        clazz = !arrayType ? rawClass : Array.newInstance(rawClass, 0).getClass();
        return clazz;
    }

    public static String writeClass(Class<?> clazz) {
        Class<?> rawType = clazz.isArray() ? clazz.getComponentType() : clazz;
        String jsonType = CastUtils.javaTypeToJsonType(rawType);
        if (jsonType == null) {
            jsonType = rawType.getCanonicalName();
        }
        String typeName = clazz.isArray() ? ARRAY_OF_PREFIX.concat(jsonType) : jsonType;
        return typeName;
    }

    public static Class<?> jsonTypeToJavaType(String jsonType) {
        if (jsonType == null || jsonType.length() == 0) {
            return null;
        }
        int index = jsonType.lastIndexOf(46);
        String type = jsonType.substring(index + 1).toLowerCase();
        if (type.intern() == "string".intern()) {
            return String.class;
        }
        if (type.intern() == "byte".intern()) {
            return Byte.TYPE;
        }
        if (type.intern() == "short".intern()) {
            return Short.TYPE;
        }
        if (type.intern() == "int".intern() || type.intern() == "integer".intern()) {
            return Integer.TYPE;
        }
        if (type.intern() == "float".intern()) {
            return Float.TYPE;
        }
        if (type.intern() == "long".intern()) {
            return Long.TYPE;
        }
        if (type.intern() == "double".intern()) {
            return Double.TYPE;
        }
        if (type.intern() == "boolean".intern()) {
            return Boolean.TYPE;
        }
        if (type.intern() == "char".intern()) {
            return Character.TYPE;
        }
        if (type.intern() == "object".intern() || type.intern() == "jsonobject".intern()) {
            return JSONObject.class;
        }
        if (type.intern() == "array".intern() || type.intern() == "jsonarray".intern()) {
            return JSONArray.class;
        }
        return null;
    }

    public static String javaTypeToJsonType(Class<?> javaType) {
        if (Character.TYPE == javaType || Character.class == javaType) {
            return "string";
        }
        if (JSONObject.class == javaType) {
            return "object";
        }
        if (JSONArray.class == javaType) {
            return "array";
        }
        if (CastUtils.isPrimitive(javaType)) {
            String canonicalName = javaType.getCanonicalName();
            int index = canonicalName.lastIndexOf(46);
            String jsonType = canonicalName.substring(index + 1);
            if ((jsonType = jsonType.toLowerCase()).intern() == "integer".intern()) {
                jsonType = "int";
            }
            return jsonType;
        }
        return null;
    }

    public static Class<?> primitiveToComparable(Class<?> type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    public static <T> T cast(Class<T> clazz, Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (JSONObject.class.isAssignableFrom(object.getClass()) || JSONArray.class.isAssignableFrom(object.getClass())) {
            return CastUtils.getObjectFromJSON(clazz, object);
        }
        if (CastUtils.isPrimitive(clazz)) {
            return CastUtils.castPrimitive(clazz, object);
        }
        if (clazz.isArray()) {
            return CastUtils.castArray(clazz, object);
        }
        String message = "Unable to cast " + object.getClass().getSimpleName() + " into " + clazz.getSimpleName();
        if (String.class.isAssignableFrom(object.getClass())) {
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, (String)object);
            }
            JSONObject objectJSONObject = null;
            JSONArray objectJSONArray = null;
            Object objectJSON = null;
            try {
                objectJSONObject = new JSONObject((String)object);
                objectJSON = objectJSONObject;
            }
            catch (JSONException e) {
                try {
                    objectJSONArray = new JSONArray((String)object);
                    objectJSON = objectJSONArray;
                }
                catch (JSONException ej) {
                    if (JSONObject.class.isAssignableFrom(clazz)) {
                        throw new ClassCastException(e.getMessage());
                    }
                    if (JSONArray.class.isAssignableFrom(clazz)) {
                        throw new ClassCastException(ej.getMessage());
                    }
                    throw new ClassCastException(message);
                }
            }
            return CastUtils.cast(clazz, objectJSON);
        }
        throw new ClassCastException(message);
    }

    public static <T> T castArray(Class<T> clazz, Object object) throws ClassCastException {
        if (!clazz.isArray()) {
            throw new ClassCastException("Destination Class is not an Array one");
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, CastUtils.cast(componentType, Array.get(object, i)));
            }
            return (T)array;
        }
        if (JSONArray.class.isAssignableFrom(object.getClass())) {
            int length = ((JSONArray)object).length();
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, CastUtils.cast(componentType, ((JSONArray)object).get(i)));
            }
            return (T)array;
        }
        if (String.class.isAssignableFrom(object.getClass())) {
            String objectStr = (String)object;
            T jsonArray = CastUtils.getObjectFromJSON(clazz, objectStr);
            if (jsonArray != null) {
                return jsonArray;
            }
            if (char[].class.equals(clazz)) {
                return (T)objectStr.toCharArray();
            }
            if (Character[].class.equals(clazz)) {
                char[] chars = objectStr.toCharArray();
                Character[] characters = new Character[chars.length];
                for (int i = 0; i < chars.length; ++i) {
                    characters[i] = Character.valueOf(chars[i]);
                }
                return (T)characters;
            }
            objectStr = objectStr.replace('[', ' ').replace(']', ' ').trim();
            return CastUtils.castArray(clazz, objectStr, COMMA_DELIMITER);
        }
        throw new ClassCastException("the object to cast is neither an instance of an Array class nor a String one");
    }

    public static <T> T castArray(Class<T> clazz, String objectStr, String delimiter) throws ClassCastException {
        if (!clazz.isArray()) {
            throw new ClassCastException("Destination Class is not an Array one");
        }
        if (objectStr.indexOf(delimiter) == -1) {
            throw new ClassCastException("Delimiter not found");
        }
        return CastUtils.castArray(clazz, objectStr.split(delimiter));
    }

    public static <T> T castPrimitive(Class<T> clazz, Object object) throws ClassCastException {
        if (!CastUtils.isPrimitive(clazz)) {
            throw new ClassCastException("Destination Class is not a Primitive one");
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        Object primitive = null;
        if (String.class == object.getClass()) {
            primitive = CastUtils.getPrimitiveFromString(clazz, (String)object);
        } else if (Character.class.isAssignableFrom(object.getClass()) || Character.TYPE.isAssignableFrom(object.getClass())) {
            primitive = CastUtils.getPrimitiveFromString(clazz, new String(new char[]{((Character)object).charValue()}));
        } else if (Boolean.class.isAssignableFrom(object.getClass()) || Boolean.TYPE.isAssignableFrom(object.getClass())) {
            primitive = CastUtils.getPrimitiveFromString(clazz, Boolean.toString((Boolean)object));
        } else if (Number.class.isAssignableFrom(object.getClass())) {
            primitive = CastUtils.getPrimitiveFromNumber(clazz, (Number)object);
        } else if (object.getClass().isPrimitive()) {
            primitive = CastUtils.getPrimitiveFromNumber(clazz, Double.valueOf(String.valueOf(object)));
        } else if (Enum.class.isAssignableFrom(object.getClass())) {
            primitive = String.class == clazz ? CastUtils.getPrimitiveFromString(clazz, ((Enum)object).name()) : CastUtils.getPrimitiveFromNumber(clazz, ((Enum)object).ordinal());
        }
        if (primitive == null) {
            throw new ClassCastException(String.format(" [%s as %s] The object cannot be cast into neither a String nor a Number", String.valueOf(object), clazz.getName()));
        }
        return (T)primitive;
    }

    public static Comparable castComparable(Object object) {
        Class<?> clazz = object.getClass();
        if (Comparable.class.isAssignableFrom(clazz)) {
            return (Comparable)object;
        }
        Double dble = CastUtils.primitiveNumberToDouble(object);
        if (dble != null) {
            return dble;
        }
        if (Character.TYPE == clazz) {
            return (Character)object;
        }
        if (Boolean.TYPE == clazz) {
            return (Boolean)object;
        }
        if (clazz.isEnum()) {
            return ((Enum)object).name();
        }
        return null;
    }

    public static <T> Object getPrimitiveFromString(Class<T> clazz, String value) {
        if (clazz == String.class) {
            return value;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        if (clazz == Character.class) {
            return new Character(value.charAt(0));
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (clazz == Boolean.class) {
            return new Boolean(Boolean.parseBoolean(value));
        }
        Double valueDouble = null;
        try {
            valueDouble = new Double(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new ClassCastException(e.getMessage());
        }
        if (clazz == Byte.class) {
            return new Byte(valueDouble.byteValue());
        }
        if (clazz == Byte.TYPE) {
            return valueDouble.byteValue();
        }
        if (clazz == Short.TYPE) {
            return valueDouble.shortValue();
        }
        if (clazz == Short.class) {
            return new Short(valueDouble.shortValue());
        }
        if (clazz == Integer.TYPE) {
            return valueDouble.intValue();
        }
        if (clazz == Integer.class) {
            return new Integer(valueDouble.intValue());
        }
        if (clazz == Double.TYPE) {
            return (double)valueDouble;
        }
        if (clazz == Double.class) {
            return valueDouble;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(valueDouble.floatValue());
        }
        if (clazz == Float.class) {
            return new Float(valueDouble.floatValue());
        }
        if (clazz == Long.TYPE) {
            return valueDouble.longValue();
        }
        if (clazz == Long.class) {
            return new Long(valueDouble.longValue());
        }
        return null;
    }

    public static <T> Object getPrimitiveFromNumber(Class<T> clazz, Number value) {
        if (clazz == Byte.class) {
            return new Byte(value.byteValue());
        }
        if (clazz == Byte.TYPE) {
            return value.byteValue();
        }
        if (clazz == Short.class) {
            return new Short(value.shortValue());
        }
        if (clazz == Short.TYPE) {
            return value.shortValue();
        }
        if (clazz == Integer.class) {
            return new Integer(value.intValue());
        }
        if (clazz == Integer.TYPE) {
            return value.intValue();
        }
        if (clazz == Double.class) {
            return new Double(value.doubleValue());
        }
        if (clazz == Double.TYPE) {
            return value.doubleValue();
        }
        if (clazz == Float.class) {
            return new Float(value.floatValue());
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (clazz == Long.class) {
            return new Long(value.longValue());
        }
        if (clazz == Long.TYPE) {
            return value.longValue();
        }
        if (clazz == String.class) {
            return String.valueOf(value);
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (clazz == Character.class) {
            return Character.valueOf(value.toString().charAt(0));
        }
        return null;
    }

    public static Double primitiveNumberToDouble(Object object) {
        Class<?> clazz = object.getClass();
        if (Number.class.isAssignableFrom(clazz)) {
            return ((Number)object).doubleValue();
        }
        if (clazz.isPrimitive()) {
            if (Byte.TYPE == object.getClass()) {
                return new Double(((Byte)object).doubleValue());
            }
            if (Short.TYPE == object.getClass()) {
                return new Double(((Short)object).doubleValue());
            }
            if (Integer.TYPE == object.getClass()) {
                return new Double(((Integer)object).doubleValue());
            }
            if (Long.TYPE == object.getClass()) {
                return new Double(((Long)object).doubleValue());
            }
            if (Float.TYPE == object.getClass()) {
                return new Double(((Float)object).doubleValue());
            }
            if (Double.TYPE == object.getClass()) {
                return (Double)object;
            }
        }
        return null;
    }

    public static <T> T getObjectFromJSON(Class<T> clazz, Object json) {
        if (json == null) {
            return null;
        }
        if (clazz.isAssignableFrom(json.getClass())) {
            return (T)json;
        }
        String message = "Unable to turn JSON " + json.toString() + " into Java [" + (clazz.getName() + "]");
        if (CastUtils.isPrimitive(clazz)) {
            if (json.getClass().equals(String.class)) {
                return (T)CastUtils.getPrimitiveFromString(clazz, (String)json);
            }
            if (Number.class.isAssignableFrom(json.getClass())) {
                return (T)CastUtils.getPrimitiveFromNumber(clazz, (Number)json);
            }
            if (JSONObject.class.isAssignableFrom(json.getClass()) && String.class.isAssignableFrom(clazz)) {
                return (T)((JSONObject)json).toString();
            }
            if (JSONArray.class.isAssignableFrom(json.getClass()) && String.class.isAssignableFrom(clazz)) {
                return (T)((JSONArray)json).toString();
            }
            return CastUtils.castPrimitive(clazz, json);
        }
        if (JSONObject.class.isAssignableFrom(json.getClass())) {
            return CastUtils.getObjectFromJSON(clazz, (JSONObject)json);
        }
        if (JSONArray.class.isAssignableFrom(json.getClass())) {
            return CastUtils.getObjectFromJSON(clazz, (JSONArray)json);
        }
        if (json.getClass().equals(String.class)) {
            try {
                return CastUtils.getObjectFromJSON(clazz, new JSONObject((String)json));
            }
            catch (JSONException e) {
                try {
                    return CastUtils.getObjectFromJSON(clazz, new JSONArray((String)json));
                }
                catch (JSONException je) {
                    LOGGER.log(Level.CONFIG, je.getMessage(), je);
                }
            }
        }
        try {
            return clazz.getConstructor(json.getClass()).newInstance(json);
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
            return null;
        }
    }

    public static <T> T getObjectFromJSON(Class<T> clazz, JSONObject jsonObject) {
        if (JSONObject.NULL.equals(jsonObject)) {
            return null;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)jsonObject.toString();
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, jsonObject.length());
            String[] names = JSONObject.getNames(jsonObject);
            for (int index = 0; index < names.length; ++index) {
                Array.set(array, index, CastUtils.getObjectFromJSON(componentType, jsonObject.get(names[index])));
            }
            return (T)array;
        }
        return ReflectUtils.instantiate(clazz, jsonObject);
    }

    public static <T> T getObjectFromJSON(Class<T> clazz, JSONArray jsonArray) {
        if (JSONObject.NULL.equals(jsonArray)) {
            return null;
        }
        if (clazz.isAssignableFrom(JSONArray.class)) {
            return (T)jsonArray;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return (T)jsonArray.toString();
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, jsonArray.length());
            for (int index = 0; index < jsonArray.length(); ++index) {
                Array.set(array, index, CastUtils.getObjectFromJSON(componentType, jsonArray.get(index)));
            }
            return (T)array;
        }
        return ReflectUtils.instantiate(clazz, jsonArray);
    }

    public static <S, T extends Map<String, S>> T toMap(Class<T> clazz, Class<S> subtype, String jsonString) {
        if (jsonString != null && jsonString.length() > 0) {
            try {
                return CastUtils.toMap(clazz, subtype, new JSONObject(jsonString));
            }
            catch (JSONException e) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
        return null;
    }

    public static <S, T extends Map<String, S>> T toMap(Class<T> clazz, Class<S> subtype, JSONObject jsonObject) {
        Map map = null;
        if (clazz.equals(Map.class)) {
            clazz = new HashMap().getClass();
        }
        try {
            map = (Map)clazz.newInstance();
            if (!JSONObject.NULL.equals(jsonObject)) {
                String[] names = JSONObject.getNames(jsonObject);
                if (names == null) {
                    return null;
                }
                int length = names.length;
                for (int position = 0; position < length; ++position) {
                    S object = CastUtils.getObjectFromJSON(subtype, jsonObject.get(names[position]));
                    if (object == null) continue;
                    map.put(names[position], object);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
        return (T)map;
    }

    public static <S, T extends List<S>> T toList(Class<T> clazz, Class<S> subtype, JSONArray jsonArray) {
        List list = null;
        if (clazz.equals(List.class)) {
            clazz = new ArrayList().getClass();
        }
        try {
            list = (List)clazz.newInstance();
            if (!JSONObject.NULL.equals(jsonArray)) {
                int length = jsonArray.length();
                for (int position = 0; position < length; ++position) {
                    S object = CastUtils.getObjectFromJSON(subtype, jsonArray.get(position));
                    if (object == null) continue;
                    list.add(object);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
            return null;
        }
        return (T)list;
    }

    public static Map<?, Object> toMap(String jsonString) {
        if (jsonString != null && jsonString.length() > 0) {
            try {
                return CastUtils.toMap(new JSONObject(jsonString));
            }
            catch (JSONException e) {
                System.out.println(e.getMessage());
            }
        }
        return null;
    }

    public static Map<?, Object> toMap(JSONObject jsonObject) {
        if (JSONObject.NULL.equals(jsonObject) || jsonObject.length() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] names = JSONObject.getNames(jsonObject);
        if (names == null) {
            return null;
        }
        int length = names.length;
        for (int position = 0; position < length; ++position) {
            Object object = jsonObject.get(names[position]);
            if (object == null) continue;
            if (JSONObject.class.isAssignableFrom(object.getClass())) {
                map.put(names[position], CastUtils.toMap((JSONObject)object));
                continue;
            }
            if (JSONArray.class.isAssignableFrom(object.getClass())) {
                map.put(names[position], CastUtils.toList((JSONArray)object));
                continue;
            }
            map.put(names[position], object);
        }
        return map;
    }

    public static List<Object> toList(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int length = jsonArray.length();
        for (int position = 0; position < length; ++position) {
            Object object = jsonArray.get(position);
            if (object == null) continue;
            if (JSONObject.class.isAssignableFrom(object.getClass())) {
                list.add(CastUtils.toMap((JSONObject)object));
                continue;
            }
            if (JSONArray.class.isAssignableFrom(object.getClass())) {
                list.add(CastUtils.toList((JSONArray)object));
                continue;
            }
            list.add(object);
        }
        return list;
    }

    public static Object copy(Class<?> type, Object value) {
        if (value == null) {
            return null;
        }
        if (type.isPrimitive() || type.isEnum()) {
            return value;
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            Object copy = Array.newInstance(type.getComponentType(), length);
            for (int index = 0; index < length; ++index) {
                Array.set(copy, index, CastUtils.copy(type.getComponentType(), Array.get(value, index)));
            }
            return copy;
        }
        if (CastUtils.isPrimitive(type)) {
            if (type == String.class) {
                return new String((String)value);
            }
            if (type == Character.class) {
                return Character.valueOf(((Character)value).charValue());
            }
            if (type == Boolean.class) {
                return (boolean)((Boolean)value);
            }
            if (type == Byte.class) {
                return (byte)((Byte)value);
            }
            if (type == Short.class) {
                return (short)((Short)value);
            }
            if (type == Integer.class) {
                return (int)((Integer)value);
            }
            if (type == Long.class) {
                return (long)((Long)value);
            }
            if (type == Float.class) {
                return Float.valueOf(((Float)value).floatValue());
            }
            if (type == Double.class) {
                return (double)((Double)value);
            }
        }
        if (JSONObject.class.isAssignableFrom(type)) {
            if (JSONObject.NULL.equals(value)) {
                return null;
            }
            String[] names = JSONObject.getNames((JSONObject)value);
            if (names == null || names.length == 0) {
                return new JSONObject();
            }
            return new JSONObject((JSONObject)value, names);
        }
        if (JSONArray.class.isAssignableFrom(type)) {
            return new JSONArray(((JSONArray)value).toString());
        }
        Class<?> alternativeClass = null;
        if (Object.class == type && Object.class != (alternativeClass = value.getClass())) {
            return CastUtils.copy(alternativeClass, value);
        }
        return value;
    }

    static {
        PRIMITIVE_AND_WRAPPERS.add(Byte.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Short.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Integer.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Float.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Long.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Double.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Boolean.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Character.TYPE);
        PRIMITIVE_AND_WRAPPERS.add(Byte.class);
        PRIMITIVE_AND_WRAPPERS.add(Short.class);
        PRIMITIVE_AND_WRAPPERS.add(Long.class);
        PRIMITIVE_AND_WRAPPERS.add(Integer.class);
        PRIMITIVE_AND_WRAPPERS.add(Float.class);
        PRIMITIVE_AND_WRAPPERS.add(Double.class);
        PRIMITIVE_AND_WRAPPERS.add(Boolean.class);
        PRIMITIVE_AND_WRAPPERS.add(Character.class);
        PRIMITIVE_AND_WRAPPERS.add(String.class);
    }
}

