/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.eclipse.sensinact.gateway.util.json.JSONValidator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtils {
    protected static final Logger LOGGER = Logger.getLogger(JSONUtils.class.getCanonicalName());
    public static final int DEFAULT_MAX_DEEP = 3;
    public static final String EMPTY = "";
    public static final String JSON_RPC_NAME = "jsonrpc";
    public static final String JSON_RPC_VERSION = "2.0";
    public static final String JSON_RPC_ID = "id";
    public static final String JSON_RPC_FUNCTION = "function";
    public static final String JSON_RPC_PROCEDURE = "procedure";
    public static final String JSON_RPC_METHOD = "method";
    public static final String JSON_RPC_PARAMS = "params";
    public static final String JSON_RPC_RESULT = "result";
    public static final String JSON_RPC_ERROR = "error";
    public static final String JSON_RPC_MESSAGE = "message";
    public static final String JSON_RPC_CODE = "code";
    public static final String JSON_TRUE = "true";
    public static final String JSON_FALSE = "false";
    public static final String JSON_NULL = "null";
    public static final char OPEN_BRACE = '{';
    public static final char CLOSE_BRACE = '}';
    public static final char OPEN_BRACKET = '[';
    public static final char CLOSE_BRACKET = ']';
    public static final char COMMA = ',';
    public static final char QUOTE = '\"';
    public static final char APOSTROPHE = '\'';
    public static final char COLON = ':';
    public static final char SEMICOLON = ';';

    public static String toJSONFormat(Object object) {
        return JSONUtils.toJSONFormat(object, new JSONWriterContext(3, object));
    }

    public static String toJSONFormat(Object object, int deep) {
        return JSONUtils.toJSONFormat(object, new JSONWriterContext(deep, object));
    }

    public static String toJSONFormat(Object object, JSONWriterContext context) {
        if (object == null) {
            return JSON_NULL;
        }
        if (JSONObject.class.isAssignableFrom(object.getClass())) {
            return ((JSONObject)object).toString();
        }
        if (JSONArray.class.isAssignableFrom(object.getClass())) {
            return ((JSONArray)object).toString();
        }
        if (object.getClass().isArray()) {
            return JSONUtils.arrayToJSONFormat(object, context);
        }
        if (List.class.isAssignableFrom(object.getClass())) {
            return JSONUtils.toJSONFormat((Object)((List)object).toArray(new Object[0]), context);
        }
        if (Map.class.isAssignableFrom(object.getClass())) {
            Iterator iterator = ((Map)object).entrySet().iterator();
            int index = 0;
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String key = JSONUtils.toJSONFormat(entry.getKey());
                if (key == null) continue;
                builder.append(index > 0 ? Character.valueOf(',') : EMPTY);
                if (!key.startsWith("\"")) {
                    builder.append('\"');
                    builder.append(key);
                    builder.append('\"');
                } else {
                    builder.append(key);
                }
                builder.append(':');
                builder.append(JSONUtils.toJSONFormat(entry.getValue()));
                ++index;
            }
            builder.append('}');
            return builder.toString();
        }
        if (String.class == object.getClass() && new JSONValidator((String)object).valid()) {
            return (String)object;
        }
        if (CastUtils.isPrimitive(object.getClass())) {
            return JSONUtils.primitiveToJSONFormat(object);
        }
        if (object.getClass().isEnum()) {
            return JSONUtils.primitiveToJSONFormat(((Enum)object).name());
        }
        try {
            Method method = object.getClass().getDeclaredMethod("getJSON", new Class[0]);
            if (method.getReturnType() == String.class) {
                return (String)method.invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, "Object to cast is not a JSONable instance");
        }
        if (context.tooDeep() || context.circularReference()) {
            return '\"' + object.toString() + '\"';
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Field field : object.getClass().getDeclaredFields()) {
            if (!field.isAccessible()) continue;
            String fieldJSON = null;
            try {
                context.decrementAndGet();
                fieldJSON = JSONUtils.toJSONFormat(field.get(object), context);
            }
            catch (Exception e) {
                continue;
            }
            if (fieldJSON == null || fieldJSON.length() <= 0) continue;
            builder.append('\"');
            builder.append(field.getName());
            builder.append('\"');
            builder.append(':');
            builder.append(fieldJSON);
        }
        builder.append('}');
        return builder.toString();
    }

    private static String arrayToJSONFormat(Object array, JSONWriterContext context) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            context.decrementAndGet();
            String json = JSONUtils.toJSONFormat(Array.get(array, i), context);
            if (json == null || json.length() <= 0) continue;
            builder.append(builder.length() > 1 ? Character.valueOf(',') : EMPTY);
            builder.append(json);
        }
        builder.append(']');
        return builder.toString();
    }

    private static String primitiveToJSONFormat(Object primitive) {
        StringBuilder builder = new StringBuilder();
        Class<?> argClass = primitive.getClass();
        if (CastUtils.isPrimitive(argClass)) {
            if (String.class.equals(argClass) || Character.class.equals(argClass) || Character.TYPE.equals(argClass)) {
                builder.append('\"');
                builder.append(primitive);
                builder.append('\"');
            } else {
                builder.append(String.valueOf(primitive));
            }
        } else {
            return JSON_NULL;
        }
        return builder.toString();
    }

    private static final class JSONWriterContext {
        public final Object jsonable;
        private int deep = 0;

        JSONWriterContext(int deep, Object jsonable) {
            this.jsonable = jsonable;
            this.deep = deep;
        }

        public boolean circularReference() {
            return false;
        }

        int decrementAndGet() {
            return --this.deep;
        }

        boolean tooDeep() {
            return this.deep < 0;
        }
    }
}

