/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.csv;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.util.csv.CVSParserCallback;
import org.eclipse.sensinact.gateway.util.csv.CVSParserContentEvent;
import org.eclipse.sensinact.gateway.util.csv.CVSParserEOFEvent;
import org.eclipse.sensinact.gateway.util.csv.CVSParserLineEvent;
import org.eclipse.sensinact.gateway.util.csv.CVSParserTitleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVParser {
    private static final Logger LOG = LoggerFactory.getLogger(CSVParser.class);
    private static final String EMPTY_TITLE = "#EMPTY_TITLE";
    public static final String EMPTY_CONTENT = "#EMPTY_CONTENT";
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("((TRUE)|(FALSE))");
    private static final Pattern INT_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([1-9][0-9]*(\\.[0-9]+)?)|(0(\\.[0-9]+)?)");
    private static final Pattern GROUP_PATTERN = Pattern.compile("(([^\",]*)|(\"[^\"]+\")),");
    Reader reader = null;

    public CSVParser(String csv) {
        if (csv == null) {
            throw new NullPointerException("Null reader");
        }
        File f = new File(csv);
        if (f.exists()) {
            try {
                this.reader = new FileReader(f);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new NullPointerException("Null reader");
            }
        } else {
            this.reader = new StringReader(csv);
        }
    }

    public CSVParser(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("Null reader");
        }
        this.reader = reader;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void parse(boolean firstLineAsTitles, boolean handleTitles, CVSParserCallback callback) {
        if (callback == null) {
            return;
        }
        index = -1;
        try {
            block2: while (true) {
                lineBuilder = new StringBuilder();
                while ((a = this.reader.read()) >= 0 && a != 10) {
                    lineBuilder.append((char)a);
                }
                if (lineBuilder.length() != 0) {
                    line = lineBuilder.toString();
                    if (++index == 0 && firstLineAsTitles && !handleTitles) continue;
                    lineEvent = new CVSParserLineEvent(index, line);
                    callback.handle(lineEvent);
                    line = line.concat(",");
                    pos = 0;
                    matcher = CSVParser.GROUP_PATTERN.matcher(line);
                    while (true) {
                        if (matcher.find()) ** break;
                        continue block2;
                        lineElement = matcher.group(1);
                        if (lineElement.startsWith("'") || lineElement.startsWith("\"")) {
                            lineElement = lineElement.substring(1);
                        }
                        if (lineElement.endsWith("'") || lineElement.endsWith("\"") || lineElement.endsWith(",")) {
                            lineElement = lineElement.substring(0, lineElement.length() - 1);
                        }
                        event /* !! */  = null;
                        if (index == 0 && firstLineAsTitles) {
                            title = null;
                            title = lineElement.length() == 0 ? "#EMPTY_TITLE" : lineElement;
                            event /* !! */  = new CVSParserTitleEvent(pos, title);
                        } else if (lineElement.length() > 0) {
                            type = null;
                            type = CSVParser.INT_PATTERN.matcher(lineElement).matches() != false ? "INT" : (CSVParser.NUMBER_PATTERN.matcher(lineElement).matches() != false ? "DOUBLE" : (CSVParser.BOOLEAN_PATTERN.matcher(lineElement.toUpperCase()).matches() != false ? "BOOL" : "TEXT"));
                            event /* !! */  = new CVSParserContentEvent(pos, type, lineElement);
                        } else {
                            event /* !! */  = new CVSParserContentEvent(pos, null, "#EMPTY_CONTENT");
                        }
                        if (event /* !! */  != null) {
                            callback.handle(event /* !! */ );
                        }
                        ++pos;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            CSVParser.LOG.error(e.getMessage(), (Throwable)e);
        }
        eofEvent = new CVSParserEOFEvent(index);
        callback.handle(eofEvent);
        this.close();
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.reader = null;
            }
        }
    }
}

