/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.util.json.JSONStatement;
import org.eclipse.sensinact.gateway.util.json.JSONTokenerStatement;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectStatement
extends JSONObject
implements JSONStatement {
    private Map<String, JSONStatement.JSONVariable> variables = new HashMap<String, JSONStatement.JSONVariable>();

    public JSONObjectStatement(String json) {
        this(new JSONTokenerStatement(json));
    }

    public JSONObjectStatement(JSONTokenerStatement tokener) {
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = tokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            tokener.back();
            String key = tokener.nextValue().toString();
            c = tokener.nextClean();
            if (c != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, tokener.nextValue());
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    @Override
    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            super.put(key, value);
            if (JSONStatement.JSONVariable.class.isAssignableFrom(value.getClass())) {
                JSONStatement.JSONVariable jsonVariable = (JSONStatement.JSONVariable)value;
                this.variables.put(jsonVariable.getName(), jsonVariable);
            }
        } else {
            this.remove(key);
        }
        return this;
    }

    @Override
    public Object remove(String key) {
        Object value = super.remove(key);
        if (value != null && JSONStatement.JSONVariable.class.isAssignableFrom(value.getClass())) {
            JSONStatement.JSONVariable jsonVariable = (JSONStatement.JSONVariable)value;
            this.variables.remove(jsonVariable.getName());
        }
        return value;
    }

    @Override
    public boolean apply(String variable, Object value) {
        JSONStatement.JSONVariable jsonVariable = this.variables.get(variable);
        if (jsonVariable != null) {
            jsonVariable.setValue(value);
            return true;
        }
        Iterator<String> iterator = super.keys();
        while (iterator.hasNext()) {
            Object object = super.get(iterator.next());
            if (!JSONStatement.class.isAssignableFrom(object.getClass()) || !((JSONStatement)object).apply(variable, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        Iterator<JSONStatement.JSONVariable> variableIterator = this.variables.values().iterator();
        while (variableIterator.hasNext()) {
            variableIterator.next().reset();
        }
        Iterator<String> iterator = super.keys();
        while (iterator.hasNext()) {
            Object object = super.get(iterator.next());
            if (!JSONStatement.class.isAssignableFrom(object.getClass())) continue;
            ((JSONStatement)object).reset();
        }
    }
}

