/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONValidator {
    private int index;
    private Reader reader;
    private char lastChar;
    private boolean useLastChar;
    private Stack<JSONToken> tokens = new Stack();

    public JSONValidator(Reader reader) {
        this.reader = reader;
        this.useLastChar = false;
        this.index = 0;
    }

    public JSONValidator(String s) {
        this(new StringReader(s));
    }

    public boolean valid() {
        try {
            JSONToken t;
            int count = 0;
            while ((t = this.nextToken()) != null) {
                ++count;
            }
            return count > 0;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void clear() {
        this.tokens.clear();
    }

    public JSONToken nextToken() throws JSONException {
        char c = this.nextClean();
        if (this.tokens.isEmpty()) {
            JSONToken co = this.checkOpening(c, null);
            if (co != null) {
                return co;
            }
            return null;
        }
        JSONToken cc = this.checkClosing(c);
        if (cc != null) {
            return cc;
        }
        JSONToken lastToken = this.tokens.pop();
        if (lastToken != null && (lastToken.equals((Object)JSONToken.JSON_ARRAY_OPENING) || lastToken.equals((Object)JSONToken.JSON_OBJECT_OPENING))) {
            this.tokens.push(lastToken);
        }
        switch (lastToken) {
            case JSON_OBJECT_OPENING: {
                String key = null;
                Object value = null;
                switch (c) {
                    case '\"': 
                    case '\'': {
                        key = this.nextString(c);
                        break;
                    }
                    default: {
                        throw this.syntaxError("Expected String delimiter");
                    }
                }
                c = this.nextClean();
                if (c == '=') {
                    if (this.next() != '>') {
                        this.back();
                    }
                } else if (c != ':') {
                    throw this.syntaxError("Expected a ':' after a key");
                }
                c = this.nextClean();
                switch (c) {
                    case '\"': 
                    case '\'': {
                        value = this.nextString(c);
                    }
                }
                if (value == null) {
                    JSONToken co = this.checkOpening(c, key);
                    if (co != null) {
                        return co;
                    }
                    StringBuffer sb = new StringBuffer();
                    while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                        sb.append(c);
                        c = this.next();
                    }
                    this.back();
                    String s = sb.toString().trim();
                    if (s.equals("")) {
                        throw this.syntaxError("Missing value");
                    }
                    value = JSONObject.stringToValue(s);
                }
                c = this.nextClean();
                switch (c) {
                    case ',': 
                    case ';': {
                        break;
                    }
                    default: {
                        this.back();
                    }
                }
                JSONToken t = JSONToken.JSON_OBJECT_ITEM;
                t.clear();
                t.setContext(new TokenContext(null, key, value));
                return t;
            }
            case JSON_ARRAY_OPENING: {
                Object value = null;
                switch (c) {
                    case ',': 
                    case ';': {
                        JSONToken t = JSONToken.JSON_ARRAY_ITEM;
                        t.clear();
                        t.setContext(new TokenContext(null, null, null));
                        return t;
                    }
                }
                cc = this.checkClosing(c);
                if (cc != null) {
                    return cc;
                }
                switch (c) {
                    case '\"': 
                    case '\'': {
                        value = this.nextString(c);
                    }
                }
                if (value == null) {
                    JSONToken co = this.checkOpening(c, null);
                    if (co != null) {
                        return co;
                    }
                    StringBuffer sb = new StringBuffer();
                    while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                        sb.append(c);
                        c = this.next();
                    }
                    this.back();
                    String s = sb.toString().trim();
                    if (s.equals("")) {
                        throw this.syntaxError("Missing value");
                    }
                    value = JSONObject.stringToValue(s);
                }
                c = this.nextClean();
                switch (c) {
                    case ',': 
                    case ';': {
                        break;
                    }
                    default: {
                        this.back();
                    }
                }
                JSONToken t = JSONToken.JSON_ARRAY_ITEM;
                t.clear();
                t.setContext(new TokenContext(null, null, value));
                return t;
            }
        }
        return null;
    }

    private void checkClosingArray() {
        if (this.tokens.isEmpty()) {
            throw this.syntaxError("Unexpected array closing");
        }
        JSONToken previousToken = this.tokens.pop();
        if (!previousToken.equals((Object)JSONToken.JSON_ARRAY_OPENING)) {
            throw this.syntaxError("Unexpected array closing");
        }
    }

    private void checkClosingObject() {
        if (this.tokens.isEmpty()) {
            throw this.syntaxError("Unexpected object closing");
        }
        JSONToken previousToken = this.tokens.pop();
        if (!previousToken.equals((Object)JSONToken.JSON_OBJECT_OPENING)) {
            throw this.syntaxError("Unexpected object closing");
        }
    }

    private JSONToken checkClosing(char c) {
        JSONToken cc = null;
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Unexpected end of stream");
            }
            case '}': {
                this.checkClosingObject();
                cc = JSONToken.JSON_OBJECT_CLOSING;
                break;
            }
            case ']': {
                this.checkClosingArray();
                cc = JSONToken.JSON_ARRAY_CLOSING;
            }
        }
        if (cc != null) {
            c = this.nextClean();
            switch (c) {
                case ',': 
                case ';': {
                    break;
                }
                default: {
                    this.back();
                }
            }
        }
        return cc;
    }

    private JSONToken checkOpening(char c, String key) {
        JSONToken o = null;
        switch (c) {
            case '{': {
                o = JSONToken.JSON_OBJECT_OPENING;
                o.setContext(new TokenContext(null, key, null));
                this.tokens.push(o);
                break;
            }
            case '[': {
                o = JSONToken.JSON_ARRAY_OPENING;
                o.setContext(new TokenContext(null, key, null));
                this.tokens.push(o);
                break;
            }
        }
        return o;
    }

    private void back() throws JSONException {
        if (this.useLastChar || this.index <= 0) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        --this.index;
        this.useLastChar = true;
    }

    private char next() throws JSONException {
        int c;
        if (this.useLastChar) {
            this.useLastChar = false;
            if (this.lastChar != '\u0000') {
                ++this.index;
            }
            return this.lastChar;
        }
        try {
            c = this.reader.read();
        }
        catch (IOException exc) {
            throw new JSONException(exc);
        }
        if (c <= 0) {
            this.lastChar = '\u0000';
            return '\u0000';
        }
        ++this.index;
        this.lastChar = (char)c;
        return this.lastChar;
    }

    private String next(int n) throws JSONException {
        if (n == 0) {
            return "";
        }
        char[] buffer = new char[n];
        int pos = 0;
        if (this.useLastChar) {
            this.useLastChar = false;
            buffer[0] = this.lastChar;
            pos = 1;
        }
        try {
            int len;
            while (pos < n && (len = this.reader.read(buffer, pos, n - pos)) != -1) {
                pos += len;
            }
        }
        catch (IOException exc) {
            throw new JSONException(exc);
        }
        this.index += pos;
        if (pos < n) {
            throw this.syntaxError("Substring bounds error");
        }
        this.lastChar = buffer[n - 1];
        return new String(buffer);
    }

    private char nextClean() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    private String nextString(char quote) throws JSONException {
        StringBuffer sb = new StringBuffer();
        block13: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block13;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    private JSONException syntaxError(String message) {
        return new JSONException(message + "\n at position " + this.index + "\n" + this.toString());
    }

    public static enum JSONToken {
        JSON_OBJECT_OPENING,
        JSON_OBJECT_CLOSING,
        JSON_OBJECT_ITEM,
        JSON_ARRAY_OPENING,
        JSON_ARRAY_CLOSING,
        JSON_ARRAY_ITEM;

        private TokenContext context;

        public void clear() {
            this.context = null;
        }

        public TokenContext getContext() {
            return this.context;
        }

        public void setContext(TokenContext context) {
            this.context = context;
        }
    }

    public static class TokenContext {
        public final String path;
        public final String key;
        public final Object value;

        TokenContext(String path, String key, Object value) {
            this.path = path;
            this.key = key;
            this.value = value;
        }
    }
}

