/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.location;

public class Point {
    public final double latitude;
    public final double longitude;
    public final double altitude;

    public static Point fromString(String s) {
        String[] coordinates = s.split(":");
        try {
            Point p = new Point(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
            return p;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Point(double latitude, double longitude) {
        this(latitude, longitude, 0.0);
    }

    public Point(double latitude, double longitude, double altitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (Point.class.isAssignableFrom(obj.getClass())) {
            Point p = (Point)obj;
            return p.latitude == this.latitude && p.longitude == this.longitude;
        }
        if (String.class == obj.getClass()) {
            return this.equals(Point.fromString((String)obj));
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.longitude);
        builder.append(",");
        builder.append(this.latitude);
        builder.append("]");
        return builder.toString();
    }

    public String toGeoJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"type\":\"Feature\",\"properties\":{},\"geometry\":{\"type\":\"Point\",\"coordinates\":[");
        builder.append(this.longitude);
        builder.append(",");
        builder.append(this.latitude);
        builder.append("]");
        builder.append("]}}");
        return builder.toString();
    }
}

