/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.location;

public class Segment {
    private double lat1;
    private double radLat1;
    private double lng1;
    private double radLng1;
    private double lat2;
    private double radLat2;
    private double lng2;
    private double radLng2;
    private double fwAz;
    private double radFwAz;
    private double revAz;
    private double radRevAz;
    private double dist;

    public Segment(double lat1, double lng1, double lat2, double lng2, double fwAz, double revAz, double dist) {
        this.setLat1(lat1);
        this.setLng1(lng1);
        this.setLat2(lat2);
        this.setLng2(lng2);
        this.setFwAz(fwAz);
        this.setRevAz(revAz);
        this.setDist(dist);
    }

    public double getLat1() {
        return this.lat1;
    }

    public double getRadLat1() {
        return this.radLat1;
    }

    void setLat1(double lat1) {
        this.lat1 = lat1;
        this.radLat1 = lat1 * (Math.PI / 180);
    }

    void setRadLat1(double radLat1) {
        this.lat1 = radLat1 * 57.29577951308232;
        this.radLat1 = radLat1;
    }

    public double getLng1() {
        return this.lng1;
    }

    public double getRadLng1() {
        return this.radLng1;
    }

    void setLng1(double lng1) {
        this.lng1 = lng1;
        this.radLng1 = lng1 * (Math.PI / 180);
    }

    void setRadLng1(double radLng1) {
        this.radLng1 = radLng1;
        this.lng1 = radLng1 * 57.29577951308232;
    }

    public double getLat2() {
        return this.lat2;
    }

    public double getRadLat2() {
        return this.radLat2;
    }

    void setLat2(double lat2) {
        this.lat2 = lat2;
        this.radLat2 = lat2 * (Math.PI / 180);
    }

    void setRadLat2(double radLat2) {
        this.lat2 = radLat2 * 57.29577951308232;
        this.radLat2 = radLat2;
    }

    public double getLng2() {
        return this.lng2;
    }

    public double getRadLng2() {
        return this.radLng2;
    }

    void setLng2(double lng2) {
        this.lng2 = lng2;
        this.radLng2 = lng2 * (Math.PI / 180);
    }

    void setRadLng2(double radLng2) {
        this.radLng2 = radLng2;
        this.lng2 = radLng2 * 57.29577951308232;
    }

    public double getForwardAzimuth() {
        return this.fwAz;
    }

    public double getRadForwardAzimuth() {
        return this.radFwAz;
    }

    void setFwAz(double fwAz) {
        if (Math.abs(fwAz) > 360.0) {
            fwAz -= Math.floor(fwAz / 360.0) * 360.0;
        }
        this.fwAz = fwAz;
        this.radFwAz = fwAz * (Math.PI / 180);
    }

    void setRadFwAz(double radFwAz) {
        if (Math.abs(radFwAz) > Math.PI * 2) {
            radFwAz -= Math.floor(radFwAz / (Math.PI * 2)) * (Math.PI * 2);
        }
        this.radFwAz = radFwAz;
        this.fwAz = radFwAz * 57.29577951308232;
    }

    public double getBackAzimuth() {
        return this.revAz;
    }

    public double geRadBackAzimuth() {
        return this.radRevAz;
    }

    void setRevAz(double revAz) {
        if (Math.abs(revAz) > 360.0) {
            revAz -= Math.floor(revAz / 360.0) * 360.0;
        }
        this.revAz = revAz;
        this.radRevAz = revAz * (Math.PI / 180);
    }

    void setRadRevAz(double radRevAz) {
        if (Math.abs(radRevAz) > Math.PI * 2) {
            radRevAz -= Math.floor(radRevAz / (Math.PI * 2)) * (Math.PI * 2);
        }
        this.radRevAz = radRevAz;
        this.revAz *= 57.29577951308232;
    }

    void setDist(double dist) {
        this.dist = dist;
    }

    public double getDistance() {
        return this.dist;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("--------------------------\n");
        builder.append(this.lat1 != 0.0 && this.lng1 != 0.0 ? "point 1:[" + this.lng1 + "," + this.lat1 + "]\n" : "");
        builder.append(this.lat2 != 0.0 && this.lng2 != 0.0 ? "point 2:[" + this.lng2 + "," + this.lat2 + "]\n" : "");
        builder.append(this.dist != 0.0 ? "distance :" + this.dist + "\n" : "\n");
        builder.append("--------------------------\n");
        return builder.toString();
    }

    public String toGeoJSON() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"type\":\"Feature\",\"properties\":{},\"geometry\":{\"type\":\"LineString\",\"coordinates\":[[");
        builder.append(this.lng1);
        builder.append(",");
        builder.append(this.lat1);
        builder.append("],[");
        builder.append(this.lng2);
        builder.append(",");
        builder.append(this.lat2);
        builder.append("]]}}");
        return builder.toString();
    }
}

