/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util.stack;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.sensinact.gateway.util.stack.StackEngineHandler;

public class StackEngine<E, H extends StackEngineHandler<E>> {
    private final int UNLIMITED_SIZE = -1;
    private final Object lock = new Object();
    private int maxStackSize;
    private final Deque<E> elements;
    private final H handler;
    private final AtomicBoolean locked;
    private final Semaphore semaphore;
    private final CountDownLatch completionLatch;
    private final AtomicBoolean running;
    private final AtomicBoolean closing;
    private final ScheduledExecutorService worker;
    private ScheduledFuture<?> unlockTask;

    StackEngine(H handler, ScheduledExecutorService worker) {
        this.handler = handler;
        this.elements = new LinkedList();
        this.semaphore = new Semaphore(1);
        this.completionLatch = new CountDownLatch(1);
        this.running = new AtomicBoolean(true);
        this.closing = new AtomicBoolean(false);
        this.locked = new AtomicBoolean(false);
        this.worker = worker;
        this.maxStackSize = -1;
        this.requestProcessingIfNeeded();
    }

    void requestProcessingIfNeeded() {
        this.worker.schedule(this::_requestProcessingIfNeeded, 100L, TimeUnit.MILLISECONDS);
    }

    void _requestProcessingIfNeeded() {
        if (this.running.get() && this.semaphore.tryAcquire()) {
            this.worker.execute(this::dequeue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dequeue() {
        boolean runAgain;
        for (int i = 0; i < 5; ++i) {
            E element = this.pop();
            try {
                if (element != null) {
                    this.handler.doHandle(element);
                    continue;
                }
                if (!this.closing.get()) break;
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stop();
            }
            break;
        }
        Object object = this.lock;
        synchronized (object) {
            runAgain = !this.elements.isEmpty();
        }
        if (runAgain) {
            this.worker.execute(this::dequeue);
        } else {
            this.semaphore.release();
        }
        if (!this.running()) {
            this.completionLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(E element) {
        if (this.closing.get()) {
            return;
        }
        if (element == null) {
            return;
        }
        int maxSize = -1;
        maxSize = this.getMaxStackSize();
        if (maxSize != -1 && this.length() == maxSize) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.elements.addLast(element);
        }
        this.requestProcessingIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFirst(E element) {
        if (this.closing.get()) {
            return;
        }
        if (element == null) {
            return;
        }
        int maxSize = -1;
        maxSize = this.getMaxStackSize();
        if (maxSize != -1 && this.length() == maxSize) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.elements.addFirst(element);
        }
        this.requestProcessingIfNeeded();
    }

    public void setMaxStackSize(int stackSize) {
        if (stackSize <= 0) {
            this.maxStackSize = -1;
            return;
        }
        this.maxStackSize = stackSize;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        int length = 0;
        Object object = this.lock;
        synchronized (object) {
            length = this.elements.size();
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    E pop() {
        E element = null;
        if (this.locked()) {
            return element;
        }
        Object object = this.lock;
        synchronized (object) {
            element = this.elements.pollFirst();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.running.set(false);
            this.elements.clear();
        }
        if (this.semaphore.tryAcquire()) {
            this.completionLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean running() {
        boolean running = false;
        Object object = this.lock;
        synchronized (object) {
            running = this.running.get();
        }
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locked() {
        boolean locked = false;
        Object object = this.lock;
        synchronized (object) {
            locked = this.locked.get();
        }
        return locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        Object object = this.lock;
        synchronized (object) {
            if (Thread.interrupted()) {
                return;
            }
            if (this.unlockTask != null) {
                this.unlockTask.cancel(false);
                this.unlockTask = null;
            }
            this.locked.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locked(long delay) {
        Object object = this.lock;
        synchronized (object) {
            if (this.unlockTask != null) {
                this.unlockTask.cancel(true);
                this.unlockTask = null;
            }
            this.unlockTask = this.worker.schedule(this::unlock, delay, TimeUnit.MILLISECONDS);
            this.locked.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeWhenEmpty() {
        this.closing.set(true);
        Object object = this.lock;
        synchronized (object) {
            if (this.elements.isEmpty()) {
                this.running.set(false);
            }
        }
        if (this.semaphore.tryAcquire()) {
            this.completionLatch.countDown();
        }
    }

    void awaitTermination() throws InterruptedException {
        this.completionLatch.await(100L, TimeUnit.MILLISECONDS);
    }

    void awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        this.completionLatch.await(time, unit);
    }
}

