/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.streams;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.aries.rsa.provider.fastbin.Activator;
import org.apache.aries.rsa.provider.fastbin.streams.Chunk;
import org.apache.aries.rsa.provider.fastbin.streams.StreamProvider;

public class OutputStreamProxy
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = -6008791618074159841L;
    private int streamID;
    private String address;
    private transient StreamProvider streamProvider;
    private transient int position;
    private transient byte[] buffer;
    private transient AtomicInteger chunkCounter;

    public OutputStreamProxy(int streamID, String address) {
        this.streamID = streamID;
        this.address = address;
        this.init();
    }

    private final void init() {
        this.buffer = new byte[65536];
        this.chunkCounter = new AtomicInteger(-1);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.streamProvider.close(this.streamID);
    }

    private void closeSilent() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        InvocationHandler handler = Activator.getInstance().getClient().getProxy(this.address, "stream-provider", this.getClass().getClassLoader());
        this.streamProvider = (StreamProvider)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{StreamProvider.class}, handler);
        this.init();
    }

    protected void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.writeInternal(b);
        }
        catch (IOException e) {
            this.closeSilent();
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.writeInternal(b, off, len);
        }
        catch (IOException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void writeInternal(int b) throws IOException {
        if (this.position == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.position++] = (byte)b;
    }

    public void writeInternal(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        int processed = 0;
        while (processed < len) {
            int available = this.buffer.length - this.position;
            int chunkLength = Math.min(len - processed, available);
            System.arraycopy(b, off, this.buffer, this.position, chunkLength);
            this.position += chunkLength;
            if ((processed += chunkLength) >= len) continue;
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flushInternal();
        }
        catch (IOException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void flushInternal() throws IOException {
        if (this.position == 0) {
            return;
        }
        byte[] toSend = this.buffer;
        if (this.position < this.buffer.length) {
            toSend = new byte[this.position];
            System.arraycopy(this.buffer, 0, toSend, 0, this.position);
        }
        Chunk chunk = new Chunk(toSend, this.chunkCounter.incrementAndGet());
        this.streamProvider.write(this.streamID, chunk);
        this.position = 0;
    }
}

