/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.watchdog;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.app.manager.json.AppSnaMessage;
import org.eclipse.sensinact.gateway.app.manager.osgi.AppServiceMediator;
import org.eclipse.sensinact.gateway.app.manager.watchdog.AbstractAppWatchDog;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.Core;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessage;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessage;
import org.eclipse.sensinact.gateway.core.message.SnaLifecycleMessageImpl;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppResourceLifecycleWatchDog
extends AbstractAppWatchDog {
    private static final Logger LOG = LoggerFactory.getLogger(AppResourceLifecycleWatchDog.class);
    private Collection<String> resourceUris;
    private Map<String, MidAgentCallback> registrations;

    public AppResourceLifecycleWatchDog(AppServiceMediator mediator, ApplicationService service, Collection<String> resourceUris) {
        super(mediator, service);
        this.resourceUris = resourceUris;
        this.registrations = new HashMap<String, MidAgentCallback>();
    }

    private Resource getResource(Session session, String uri) {
        String[] uriElements = UriUtils.getUriElements((String)uri);
        if (uriElements.length != 3) {
            return null;
        }
        return session.resource(uriElements[0], uriElements[1], uriElements[2]);
    }

    @Override
    public SnaErrorMessage start(Session session) {
        for (String resourceUri : this.resourceUris) {
            try {
                String[] uriElements = UriUtils.getUriElements((String)resourceUri);
                if (uriElements[0].indexOf(40) > -1 || uriElements.length == 3 && session.getResource(uriElements[0], uriElements[1], uriElements[2]).getStatusCode() == 200) continue;
                throw new NullPointerException();
            }
            catch (NullPointerException e) {
                return new AppSnaMessage("/AppManager", SnaErrorMessage.Error.SYSTEM_ERROR, "Resource " + resourceUri + " does not exist or you are not allowed to access it.");
            }
        }
        this.mediator.callService(Core.class, (Executable)new Executable<Core, Void>(){

            public Void execute(Core service) throws Exception {
                for (String resourceUri : AppResourceLifecycleWatchDog.this.resourceUris) {
                    String[] uriElements = UriUtils.getUriElements((String)resourceUri);
                    if (uriElements[0].indexOf(40) > -1) continue;
                    SnaFilter filter = new SnaFilter((Mediator)AppResourceLifecycleWatchDog.this.mediator, resourceUri);
                    filter.addHandledType(SnaMessage.Type.LIFECYCLE);
                    AppResourceLifeCycleSnaAgent callback = new AppResourceLifeCycleSnaAgent(AppResourceLifecycleWatchDog.this.mediator, AppResourceLifecycleWatchDog.this);
                    AppResourceLifecycleWatchDog.this.registrations.put(service.registerAgent((Mediator)AppResourceLifecycleWatchDog.this.mediator, (MidAgentCallback)callback, filter), callback);
                }
                return null;
            }
        });
        return null;
    }

    @Override
    public SnaErrorMessage stop(Session session) {
        Iterator<MidAgentCallback> iterator = this.registrations.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().stop();
        }
        return null;
    }

    private class AppResourceLifeCycleSnaAgent
    extends AbstractMidAgentCallback {
        private AbstractAppWatchDog watchDog;

        AppResourceLifeCycleSnaAgent(Mediator mediator, AbstractAppWatchDog watchDog) {
            this.watchDog = watchDog;
        }

        public void doHandle(SnaLifecycleMessageImpl message) {
            try {
                Attribute attribute = AppResourceLifecycleWatchDog.this.service.getResource("status").getAttribute("value");
                ApplicationStatus status = (ApplicationStatus)((Object)attribute.getValue());
                block1 : switch ((SnaLifecycleMessage.Lifecycle)message.getType()) {
                    case RESOURCE_APPEARING: {
                        break;
                    }
                    case RESOURCE_DISAPPEARING: {
                        switch (status) {
                            case ACTIVE: 
                            case INSTALLED: 
                            case RESOLVING: {
                                this.watchDog.alert("Resource " + message.getPath() + " disappeared");
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

