/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.dao.directive;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sensinact.gateway.core.security.dao.directive.Directive;
import org.eclipse.sensinact.gateway.core.security.dao.directive.KeyDirective;
import org.eclipse.sensinact.gateway.core.security.entity.SnaEntity;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Column;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.PrimaryKey;
import org.eclipse.sensinact.gateway.core.security.entity.annotation.Table;

public class UpdateDirective
extends Directive {
    protected Map<String, Object> update = new HashMap<String, Object>();
    protected KeyDirective keyDirective;

    public static <E extends SnaEntity> UpdateDirective getUpdateDirective(E entity) {
        int length;
        Class<?> entityType = entity.getClass();
        Table table = entityType.getAnnotation(Table.class);
        PrimaryKey primaryKey = entityType.getAnnotation(PrimaryKey.class);
        Map<Field, Column> fields = SnaEntity.getFields(entityType);
        KeyDirective keyDirective = KeyDirective.createKeyDirective(table, primaryKey, fields);
        keyDirective.assign(entity);
        UpdateDirective updateDirective = new UpdateDirective(table.value(), keyDirective);
        Iterator<Map.Entry<Field, Column>> iterator = fields.entrySet().iterator();
        String[] keys = primaryKey == null ? null : primaryKey.value();
        int index = 0;
        int n = length = keys == null ? 0 : keys.length;
        while (iterator.hasNext()) {
            Map.Entry<Field, Column> entry = iterator.next();
            for (index = 0; index < length && !keys[index].equals(entry.getValue().value()); ++index) {
            }
            if (index < length) continue;
            updateDirective.update(entry.getValue().value(), entity.getFieldValue(entry.getKey()));
        }
        return updateDirective;
    }

    public UpdateDirective(String table, KeyDirective keyDirective) {
        super(table);
        this.keyDirective = keyDirective;
    }

    public void update(String column, Object value) {
        if (column == null || column.length() == 0) {
            return;
        }
        this.update.put(column, value);
    }

    public String toString() {
        if (this.update.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE").append(" ");
        builder.append(this.table).append(" ");
        Iterator<Map.Entry<String, Object>> iterator = this.update.entrySet().iterator();
        Map.Entry<String, Object> entry = null;
        if (iterator.hasNext()) {
            entry = iterator.next();
            builder.append("SET").append(" ");
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(super.getStringValue(entry.getValue()));
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            builder.append(",");
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(super.getStringValue(entry.getValue()));
        }
        builder.append(" ");
        builder.append("WHERE");
        builder.append(" ");
        builder.append(this.keyDirective.getValueDirective());
        String updateDirective = builder.toString();
        return updateDirective;
    }
}

