/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.rsa.discovery.endpoint.EndpointDescriptionParser;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperEndpointRepository
implements Closeable,
Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperEndpointRepository.class);
    private final ZooKeeper zk;
    private final EndpointDescriptionParser parser;
    private EndpointEventListener listener;
    public static final String PATH_PREFIX = "/osgi/service_registry";
    private Map<String, EndpointDescription> nodes = new ConcurrentHashMap<String, EndpointDescription>();

    public ZookeeperEndpointRepository(ZooKeeper zk) {
        this(zk, null);
    }

    public ZookeeperEndpointRepository(ZooKeeper zk, EndpointEventListener listener) {
        this.zk = zk;
        this.listener = listener;
        this.parser = new EndpointDescriptionParser();
        try {
            this.createPath(PATH_PREFIX);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create base path");
        }
        this.registerWatcher();
    }

    public void addListener(EndpointEventListener listener) {
        this.listener = listener;
    }

    public EndpointDescription read(String path) {
        return this.nodes.get(path);
    }

    public void add(EndpointDescription endpoint) throws KeeperException, InterruptedException {
        String path = ZookeeperEndpointRepository.getZooKeeperPath(endpoint.getId());
        LOG.info("Exporting endpoint to zookeeper. Endpoint: {}, Path: {}", (Object)endpoint, (Object)path);
        this.createBasePath();
        this.createEphemeralNode(path, this.getData(endpoint));
    }

    public void modify(EndpointDescription endpoint) throws KeeperException, InterruptedException {
        String path = ZookeeperEndpointRepository.getZooKeeperPath(endpoint.getId());
        LOG.info("Changing endpoint in zookeeper. Endpoint: {}, Path: {}", (Object)endpoint, (Object)path);
        this.createBasePath();
        this.zk.setData(path, this.getData(endpoint), -1);
    }

    public void remove(EndpointDescription endpoint) throws InterruptedException, KeeperException {
        String path = ZookeeperEndpointRepository.getZooKeeperPath(endpoint.getId());
        LOG.info("Removing endpoint in zookeeper. Endpoint: {}, Path: {}", (Object)endpoint, (Object)path);
        this.zk.delete(path, -1);
    }

    public Collection<EndpointDescription> getAll() {
        return this.nodes.values();
    }

    public static List<String> removeEmpty(List<String> strings) {
        ArrayList<String> result = new ArrayList<String>();
        if (strings == null) {
            return result;
        }
        for (String s : strings) {
            if (s == null || s.isEmpty()) continue;
            result.add(s);
        }
        return result;
    }

    public static String getZooKeeperPath(String name) {
        String escaped = name.replace('/', '#');
        return name == null || name.isEmpty() ? PATH_PREFIX : "/osgi/service_registry/" + escaped;
    }

    public void process(WatchedEvent event) {
        LOG.info("Received event {}", (Object)event);
        switch (event.getType()) {
            case NodeCreated: 
            case NodeDataChanged: 
            case NodeChildrenChanged: {
                this.watchRecursive(event.getPath());
                break;
            }
            case NodeDeleted: {
                this.handleRemoved(event.getPath());
                break;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.nodes.clear();
    }

    private void createBasePath() throws KeeperException, InterruptedException {
        String path = ZookeeperEndpointRepository.getZooKeeperPath("");
        this.createPath(path);
    }

    private void registerWatcher() {
        try {
            this.watchRecursive(PATH_PREFIX);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
        }
    }

    private void watchRecursive(String path) {
        LOG.info("Watching {}", (Object)path);
        try {
            this.handleZNodeChanged(path);
            List children = this.zk.getChildren(path, (Watcher)this);
            if (children == null) {
                return;
            }
            for (String child : children) {
                String childPath = (path.endsWith("/") ? path : path + "/") + child;
                this.watchRecursive(childPath);
            }
        }
        catch (KeeperException.ConnectionLossException | KeeperException.NoNodeException | KeeperException.SessionExpiredException e) {
            LOG.debug(e.getMessage(), e);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] getData(EndpointDescription epd) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.parser.writeEndpoint(epd, (OutputStream)bos);
        return bos.toByteArray();
    }

    private void createEphemeralNode(String fullPath, byte[] data) throws KeeperException, InterruptedException {
        try {
            this.zk.create(fullPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.info("node for endpoint already exists, recreating: {}", (Object)fullPath);
            try {
                this.zk.delete(fullPath, -1);
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            this.zk.create(fullPath, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
    }

    private void createPath(String path) throws KeeperException, InterruptedException {
        StringBuilder current = new StringBuilder();
        List<String> parts = ZookeeperEndpointRepository.removeEmpty(Arrays.asList(path.split("/")));
        for (String part : parts) {
            current.append('/');
            current.append(part);
            try {
                if (this.zk.exists(current.toString(), false) != null) continue;
                this.zk.create(current.toString(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {}
        }
    }

    private void handleZNodeChanged(String path) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        byte[] data = this.zk.getData(path, (Watcher)this, stat);
        if (data == null || data.length == 0) {
            return;
        }
        EndpointDescription endpoint = this.parser.readEndpoint((InputStream)new ByteArrayInputStream(data));
        if (endpoint != null) {
            this.handleChanged(path, endpoint);
        }
    }

    private void handleRemoved(String path) {
        EndpointDescription endpoint = this.nodes.remove(path);
        EndpointEvent event = new EndpointEvent(2, endpoint);
        if (this.listener != null) {
            this.listener.endpointChanged(event, null);
        }
    }

    private void handleChanged(String path, EndpointDescription endpoint) {
        EndpointDescription old = this.nodes.put(path, endpoint);
        int type = old == null ? 1 : 4;
        EndpointEvent event = new EndpointEvent(type, endpoint);
        if (this.listener != null) {
            this.listener.endpointChanged(event, null);
        }
    }
}

