/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper.subscribe;

import org.apache.aries.rsa.discovery.zookeeper.subscribe.InterestManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.ServiceTracker;

public class EndpointListenerTracker
extends ServiceTracker {
    private final InterestManager imManager;

    public EndpointListenerTracker(BundleContext bctx, InterestManager imManager) {
        super(bctx, EndpointListenerTracker.getFilter(), null);
        this.imManager = imManager;
    }

    private static Filter getFilter() {
        String filterSt = String.format("(|(objectClass=%s)(objectClass=%s))", EndpointEventListener.class.getName(), EndpointListener.class.getName());
        try {
            return FrameworkUtil.createFilter((String)filterSt);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Object addingService(ServiceReference sref) {
        Object epListener = super.addingService(sref);
        this.imManager.addInterest(sref, epListener);
        return epListener;
    }

    public void modifiedService(ServiceReference sref, Object epListener) {
        this.imManager.addInterest(sref, epListener);
    }

    public void removedService(ServiceReference sref, Object epListener) {
        this.imManager.removeInterest((ServiceReference<EndpointEventListener>)sref);
        super.removedService(sref, epListener);
    }
}

