/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.datastore.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreConnectionProvider;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcDataStoreService
implements DataStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataStoreService.class);
    protected final Object lock = new Object();

    protected abstract long getLastInsertedId(Statement var1) throws SQLException;

    protected abstract DataStoreConnectionProvider<Connection> getDataBaseConnectionProvider();

    protected abstract void stop();

    protected JSONArray resultSetToJSon(ResultSet resultSet) throws SQLException, JSONException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JSONArray result = new JSONArray();
        while (resultSet.next()) {
            JSONObject obj = new JSONObject();
            for (int index = 1; index <= columnCount; ++index) {
                int n;
                String column = rsmd.getColumnName(index);
                Object value = resultSet.getObject(column);
                if (value == null) continue;
                String[] columnElements = column.split("#");
                JSONObject parent = obj;
                Object subObj = null;
                for (n = 0; n < columnElements.length - 1; ++n) {
                    subObj = parent.opt(columnElements[n]);
                    if (subObj == null) {
                        subObj = new JSONObject();
                        parent.put(columnElements[n], subObj);
                    }
                    parent = (JSONObject)subObj;
                }
                parent.put(columnElements[n], value);
            }
            result.put((Object)obj);
        }
        return result;
    }

    protected String resultSetToJSonString(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        StringBuilder builder = new StringBuilder();
        int line = 0;
        builder.append("[");
        while (resultSet.next()) {
            JSONObject obj = new JSONObject();
            for (int index = 1; index <= columnCount; ++index) {
                int n;
                String column = rsmd.getColumnName(index);
                Object value = resultSet.getObject(column);
                if (value == null) continue;
                String[] columnElements = column.split("#");
                JSONObject parent = obj;
                Object subObj = null;
                for (n = 0; n < columnElements.length - 1; ++n) {
                    subObj = parent.opt(columnElements[n]);
                    if (subObj == null) {
                        subObj = new JSONObject();
                        parent.put(columnElements[n], subObj);
                    }
                    parent = (JSONObject)subObj;
                }
                parent.put(columnElements[n], value);
            }
            if (line > 0) {
                builder.append(',');
            }
            builder.append(obj.toString());
            ++line;
        }
        builder.append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R executeStatement(Executable<Statement, R> executor) {
        Statement statement = null;
        DataStoreConnectionProvider<Connection> provider = this.getDataBaseConnectionProvider();
        Object result = null;
        if (provider == null) {
            return (R)result;
        }
        try {
            Connection connection = this.getDataBaseConnectionProvider().openConnection();
            Object object = this.lock;
            synchronized (object) {
                statement = connection.createStatement();
                statement.setQueryTimeout(30);
            }
            result = executor.execute((Object)statement);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOG.error("Error while closing statement", (Throwable)e);
                }
            }
            if (provider != null) {
                provider.closeConnection();
            }
        }
        return (R)result;
    }

    public String selectAsString(final String query) {
        return this.executeStatement(new Executable<Statement, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String execute(Statement statement) throws Exception {
                try {
                    ResultSet rs = null;
                    Object object = JdbcDataStoreService.this.lock;
                    synchronized (object) {
                        rs = statement.executeQuery(query);
                    }
                    String result = JdbcDataStoreService.this.resultSetToJSonString(rs);
                    return result;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
    }

    @Override
    public JSONArray select(final String query) {
        return this.executeStatement(new Executable<Statement, JSONArray>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public JSONArray execute(Statement statement) throws Exception {
                try {
                    ResultSet rs = null;
                    Object object = JdbcDataStoreService.this.lock;
                    synchronized (object) {
                        rs = statement.executeQuery(query);
                    }
                    JSONArray result = JdbcDataStoreService.this.resultSetToJSon(rs);
                    return result;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        });
    }

    @Override
    public long insert(final String query) {
        return this.executeStatement(new Executable<Statement, Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long execute(Statement statement) throws Exception {
                long lastID = -1L;
                Object object = JdbcDataStoreService.this.lock;
                synchronized (object) {
                    try {
                        statement.addBatch(query);
                        statement.executeBatch();
                        lastID = JdbcDataStoreService.this.getLastInsertedId(statement);
                        Connection connection = statement.getConnection();
                        connection.commit();
                    }
                    catch (Exception e) {
                        Object object2 = JdbcDataStoreService.this.lock;
                        synchronized (object2) {
                            try {
                                statement.getConnection().rollback();
                            }
                            catch (SQLException ex) {
                                throw new DataStoreException(ex);
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        throw new DataStoreException(e);
                    }
                }
                return lastID;
            }
        });
    }

    @Override
    public int delete(String query) {
        return this.doQuery(query);
    }

    @Override
    public int update(String query) {
        return this.doQuery(query);
    }

    protected Integer doQuery(final String query) {
        return this.executeStatement(new Executable<Statement, Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer execute(Statement statement) throws Exception {
                int[] updateCounts = new int[]{-1};
                Object object = JdbcDataStoreService.this.lock;
                synchronized (object) {
                    try {
                        statement.addBatch(query);
                        updateCounts = statement.executeBatch();
                        Connection connection = statement.getConnection();
                        connection.commit();
                    }
                    catch (Exception e) {
                        if (statement != null) {
                            try {
                                statement.getConnection().rollback();
                            }
                            catch (SQLException ex) {
                                throw new DataStoreException(ex);
                            }
                        }
                        throw e;
                    }
                }
                return updateCounts[0];
            }
        });
    }
}

