/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.http.forward.internal;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.nthbnd.http.forward.ForwardingService;
import org.eclipse.sensinact.gateway.nthbnd.http.forward.internal.ForwardingFilter;
import org.eclipse.sensinact.gateway.nthbnd.http.forward.internal.ForwardingServlet;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireHttpWhiteboard
public class ForwardingFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingFactory.class);
    private Mediator mediator;
    private String appearingKey;
    private String disappearingKey;
    private Map<String, ServiceRegistration<?>[]> registrations;
    private final AtomicBoolean running;

    public ForwardingFactory(Mediator mediator) {
        this.mediator = mediator;
        this.registrations = Collections.synchronizedMap(new HashMap());
        this.running = new AtomicBoolean(false);
    }

    public void start() {
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        this.attachAll();
        this.appearingKey = this.mediator.attachOnServiceAppearing(ForwardingService.class, (String)null, (Executable)new Executable<ForwardingService, Void>(){

            public Void execute(ForwardingService forwardingService) throws Exception {
                ForwardingFactory.this.attach(forwardingService);
                return null;
            }
        });
        this.disappearingKey = this.mediator.attachOnServiceDisappearing(ForwardingService.class, (String)null, (Executable)new Executable<ForwardingService, Void>(){

            public Void execute(ForwardingService forwardingService) throws Exception {
                ForwardingFactory.this.detach(forwardingService);
                return null;
            }
        });
    }

    public void stop() {
        if (!this.running.get()) {
            return;
        }
        this.running.set(false);
        this.mediator.detachOnServiceAppearing(ForwardingService.class, (String)null, this.appearingKey);
        this.mediator.detachOnServiceDisappearing(ForwardingService.class, (String)null, this.disappearingKey);
        this.detachAll();
    }

    public void detachAll() {
        this.mediator.callServices(ForwardingService.class, (Executable)new Executable<ForwardingService, Void>(){

            public Void execute(ForwardingService forwardingService) throws Exception {
                ForwardingFactory.this.detach(forwardingService);
                return null;
            }
        });
    }

    public void attachAll() {
        this.mediator.callServices(ForwardingService.class, (Executable)new Executable<ForwardingService, Void>(){

            public Void execute(ForwardingService forwardingService) throws Exception {
                ForwardingFactory.this.attach(forwardingService);
                return null;
            }
        });
    }

    public final void attach(ForwardingService forwardingService) {
        if (forwardingService == null || !this.running.get()) {
            return;
        }
        String endpoint = forwardingService.getPattern();
        if (endpoint == null || endpoint.length() == 0 || "/".equals(endpoint)) {
            LOG.error("Invalid endpoint '%s' - expected '^|/([^/]+)(/([^/]+)*'", (Object)endpoint);
            return;
        }
        if (!endpoint.startsWith("/")) {
            endpoint = "/".concat(endpoint);
        }
        if (this.registrations.containsKey(endpoint)) {
            LOG.error("A forwarding service is already registered at '%s'", (Object)endpoint);
            return;
        }
        ForwardingFilter forwardingFilter = new ForwardingFilter(forwardingService);
        Dictionary<String, Object> propsGiven = forwardingService.getProperties();
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        Enumeration<String> enumKeys = propsGiven.keys();
        while (enumKeys.hasMoreElements()) {
            String key = enumKeys.nextElement();
            ((Dictionary)props).put(key, propsGiven.get(key));
        }
        ((Dictionary)props).put("osgi.http.whiteboard.filter.pattern", endpoint);
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
        ServiceRegistration[] registrations = new ServiceRegistration[2];
        registrations[0] = this.mediator.getContext().registerService(Filter.class, (Object)forwardingFilter, props);
        props = new Hashtable();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", endpoint);
        ((Dictionary)props).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=default)");
        registrations[1] = this.mediator.getContext().registerService(Servlet.class, (Object)new ForwardingServlet(), props);
        this.registrations.put(endpoint, registrations);
    }

    public final void detach(ForwardingService forwardingService) {
        if (forwardingService == null) {
            return;
        }
        String endpoint = forwardingService.getPattern();
        ServiceRegistration<?>[] registrations = this.registrations.remove(endpoint);
        if (registrations != null) {
            for (ServiceRegistration<?> registration : registrations) {
                try {
                    registration.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            LOG.info("Forwarding filter and servlet  for '%s' pattern are unregistered", (Object)endpoint);
        }
    }
}

