/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class RegistrationManager<T> {
    private final Lock registrationLock = new ReentrantLock();
    private final List<RegStateWrapper> opqueue = new ArrayList<RegStateWrapper>();
    private volatile T m_serviceRegistration;

    RegistrationManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeRegistration(RegState desired, String[] services) {
        boolean bl;
        block50: {
            RegStateWrapper rsw;
            block48: {
                boolean bl2;
                block49: {
                    block45: {
                        boolean bl3;
                        block47: {
                            block44: {
                                boolean bl4;
                                block46: {
                                    rsw = null;
                                    this.registrationLock.lock();
                                    if (!this.opqueue.isEmpty()) break block44;
                                    if (desired == RegState.unregistered != (this.m_serviceRegistration == null)) break block45;
                                    this.log(4, "Already in desired state {0}", null, new Object[]{desired});
                                    bl4 = false;
                                    this.registrationLock.unlock();
                                    if (rsw == null) break block46;
                                    try {
                                        if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                            this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                            this.reportTimeout();
                                        }
                                    }
                                    catch (InterruptedException e) {
                                        try {
                                            if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                                this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                                this.reportTimeout();
                                            }
                                        }
                                        catch (InterruptedException e1) {
                                            this.log(1, "Interrupted twice waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                        }
                                        Thread.currentThread().interrupt();
                                    }
                                }
                                return bl4;
                            }
                            if (this.opqueue.get(this.opqueue.size() - 1).getRegState() != desired) break block45;
                            this.log(4, "Duplicate request on other thread: registration change queue {0}", null, this.opqueue);
                            rsw = this.opqueue.get(this.opqueue.size() - 1);
                            bl3 = false;
                            this.registrationLock.unlock();
                            if (rsw == null) break block47;
                            try {
                                if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                    this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                    this.reportTimeout();
                                }
                            }
                            catch (InterruptedException e) {
                                try {
                                    if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                        this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                        this.reportTimeout();
                                    }
                                }
                                catch (InterruptedException e1) {
                                    this.log(1, "Interrupted twice waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                }
                                Thread.currentThread().interrupt();
                            }
                        }
                        return bl3;
                    }
                    rsw = new RegStateWrapper(desired);
                    this.opqueue.add(rsw);
                    if (this.opqueue.size() <= 1) break block48;
                    this.log(4, "Allowing other thread to process request: registration change queue {0}", null, this.opqueue);
                    bl2 = true;
                    this.registrationLock.unlock();
                    if (rsw == null) break block49;
                    try {
                        if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                            this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                            this.reportTimeout();
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                this.reportTimeout();
                            }
                        }
                        catch (InterruptedException e1) {
                            this.log(1, "Interrupted twice waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                return bl2;
            }
            try {
                do {
                    this.log(4, "registration change queue {0}", null, this.opqueue);
                    RegStateWrapper next = this.opqueue.get(0);
                    T serviceRegistration = this.m_serviceRegistration;
                    if (next.getRegState() == RegState.unregistered) {
                        this.m_serviceRegistration = null;
                    }
                    this.registrationLock.unlock();
                    try {
                        if (next.getRegState() == RegState.registered) {
                            serviceRegistration = this.register(services);
                            continue;
                        }
                        if (serviceRegistration != null) {
                            this.unregister(serviceRegistration);
                            continue;
                        }
                        this.log(1, "Unexpected unregistration request with no registration present", new Exception("Stack trace"), new Object[0]);
                    }
                    finally {
                        this.registrationLock.lock();
                        this.opqueue.remove(0);
                        if (next.getRegState() == RegState.registered) {
                            this.m_serviceRegistration = serviceRegistration;
                            this.postRegister(this.m_serviceRegistration);
                        }
                        next.getLatch().countDown();
                    }
                } while (!this.opqueue.isEmpty());
                bl = true;
                this.registrationLock.unlock();
                if (rsw == null) break block50;
            }
            catch (Throwable throwable) {
                this.registrationLock.unlock();
                if (rsw != null) {
                    try {
                        if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                            this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                            this.reportTimeout();
                        }
                    }
                    catch (InterruptedException e) {
                        try {
                            if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                                this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                                this.reportTimeout();
                            }
                        }
                        catch (InterruptedException e1) {
                            this.log(1, "Interrupted twice waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                        }
                        Thread.currentThread().interrupt();
                    }
                }
                throw throwable;
            }
            try {
                if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                    this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                    this.reportTimeout();
                }
            }
            catch (InterruptedException e) {
                try {
                    if (!rsw.getLatch().await(this.getTimeout(), TimeUnit.MILLISECONDS)) {
                        this.log(1, "Timeout waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                        this.reportTimeout();
                    }
                }
                catch (InterruptedException e1) {
                    this.log(1, "Interrupted twice waiting for reg change to complete {0}", null, new Object[]{rsw.getRegState()});
                }
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    abstract T register(String[] var1);

    abstract void postRegister(T var1);

    abstract void unregister(T var1);

    abstract void log(int var1, String var2, Throwable var3, Object ... var4);

    abstract long getTimeout();

    abstract void reportTimeout();

    T getServiceRegistration() {
        return this.m_serviceRegistration;
    }

    private static class RegStateWrapper {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final RegState regState;

        RegStateWrapper(RegState regState) {
            this.regState = regState;
        }

        public RegState getRegState() {
            return this.regState;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public int hashCode() {
            return this.regState.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof RegStateWrapper && this.regState == ((RegStateWrapper)other).getRegState();
        }

        public String toString() {
            return this.regState.toString();
        }
    }

    static enum RegState {
        unregistered,
        registered;

    }
}

