/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.sensinact.gateway.generic.TaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDesynchronizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskDesynchronizer.class);
    private final LinkedList<TaskManager> listeners = new LinkedList();
    private final AtomicInteger leftTasks = new AtomicInteger(1);
    private boolean running = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocked(boolean locked) {
        AtomicInteger atomicInteger = this.leftTasks;
        synchronized (atomicInteger) {
            this.leftTasks.set(locked ? 0 : 1);
        }
    }

    public void require(TaskManager desynchronizedService) {
        this.require(desynchronizedService, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void require(TaskManager listener, int count) {
        AtomicInteger atomicInteger = this.leftTasks;
        synchronized (atomicInteger) {
            for (int i = 0; i < count; ++i) {
                this.listeners.offer(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeingToken() {
        AtomicInteger atomicInteger = this.leftTasks;
        synchronized (atomicInteger) {
            this.leftTasks.incrementAndGet();
        }
    }

    public void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskManager listener = null;
        while (this.running) {
            listener = null;
            AtomicInteger atomicInteger = this.leftTasks;
            synchronized (atomicInteger) {
                if (this.leftTasks.get() > 0 && (listener = this.listeners.poll()) != null) {
                    this.leftTasks.decrementAndGet();
                }
            }
            if (listener != null) {
                listener.nextTask();
                continue;
            }
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e) {
                this.running = false;
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                Thread.interrupted();
            }
        }
    }
}

