/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi.impl.security;

public class Authorization {
    protected final String topic;
    protected final Permission permission;

    Authorization(String topic) {
        this(topic, Permission.READWRITE);
    }

    Authorization(String topic, Permission permission) {
        this.topic = topic;
        this.permission = permission;
    }

    public boolean grant(Permission desiredPermission) {
        return this.permission == desiredPermission || this.permission == Permission.READWRITE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authorization that = (Authorization)o;
        if (this.permission != that.permission) {
            return false;
        }
        return this.topic.equals(that.topic);
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.permission.hashCode();
        return result;
    }

    static enum Permission {
        READ,
        WRITE,
        READWRITE;

    }
}

