/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.filtering;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.filtering.Filtering;
import org.eclipse.sensinact.gateway.core.filtering.FilteringDefinition;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringAccessor
extends FilteringDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(FilteringAccessor.class);
    private ServiceReference<Filtering> reference;
    private Mediator mediator;

    public FilteringAccessor(Mediator mediator, FilteringDefinition filteringDefinition) {
        super(filteringDefinition.type, filteringDefinition.filter);
        this.mediator = mediator;
        try {
            Collection references = mediator.getContext().getServiceReferences(Filtering.class, String.format("(%s=%s)", "sensinact.filtering.type", this.type));
            if (references == null || references.size() != 1) {
                throw new RuntimeException("Unable to retrieve the appropriate Filtering service reference");
            }
            this.reference = (ServiceReference)references.iterator().next();
        }
        catch (NoSuchElementException | InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean handle(String type) {
        if (type == null) {
            return false;
        }
        Filtering filtering = (Filtering)this.mediator.getContext().getService(this.reference);
        if (filtering == null) {
            LOG.error("Unable to retrieve the appropriate Filtering service");
            return false;
        }
        boolean handle = filtering.handle(type);
        this.mediator.getContext().ungetService(this.reference);
        return handle;
    }

    public String getLDAPComponent() {
        Filtering filtering = (Filtering)this.mediator.getContext().getService(this.reference);
        if (filtering == null) {
            LOG.error("Unable to retrieve the appropriate Filtering service");
            return null;
        }
        String ldap = filtering.getLDAPComponent(this.filter);
        this.mediator.getContext().ungetService(this.reference);
        return ldap;
    }

    public String apply(Object obj) {
        Filtering filtering = (Filtering)this.mediator.getContext().getService(this.reference);
        if (filtering == null) {
            LOG.error("Unable to retrieve the appropriate Filtering service");
            return null;
        }
        String result = filtering.apply(this.filter, obj);
        this.mediator.getContext().ungetService(this.reference);
        return result;
    }
}

