/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.message.MessageRouter;
import org.eclipse.sensinact.gateway.core.message.MidCallback;
import org.eclipse.sensinact.gateway.core.message.SnaAgent;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.core.message.SnaMessageSubType;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.eclipse.sensinact.gateway.util.stack.AbstractStackEngineHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnaMessageListener
extends AbstractStackEngineHandler<SnaMessage<?>>
implements MessageRouter {
    private static final Logger LOG = LoggerFactory.getLogger(SnaMessageListener.class);
    protected final Map<SnaFilter, List<MidCallback>> callbacks;
    protected final Map<String, List<MethodAccessibility>> agentsAccessibility;
    private SensiNactResourceModelConfiguration configuration;
    private Mediator mediator;

    public SnaMessageListener(Mediator mediator, SensiNactResourceModelConfiguration configuration) {
        this.mediator = mediator;
        this.configuration = configuration;
        this.callbacks = new HashMap<SnaFilter, List<MidCallback>>();
        this.agentsAccessibility = new HashMap<String, List<MethodAccessibility>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(SnaFilter filter, MidCallback callback) {
        if (filter == null || callback == null || !callback.isActive()) {
            return;
        }
        Map<SnaFilter, List<MidCallback>> map = this.callbacks;
        synchronized (map) {
            List<MidCallback> list = this.callbacks.get(filter);
            if (list == null) {
                list = new LinkedList<MidCallback>();
                this.callbacks.put(filter, list);
            }
            list.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCallback(String callback) {
        Map<SnaFilter, List<MidCallback>> map = this.callbacks;
        synchronized (map) {
            Iterator<Map.Entry<SnaFilter, List<MidCallback>>> iterator = this.callbacks.entrySet().iterator();
            block3: while (iterator.hasNext()) {
                Map.Entry<SnaFilter, List<MidCallback>> entry = iterator.next();
                List<MidCallback> list = entry.getValue();
                Iterator<MidCallback> it2 = list.iterator();
                while (it2.hasNext()) {
                    MidCallback mid = it2.next();
                    if (!mid.getName().equals(callback)) continue;
                    it2.remove();
                    if (!list.isEmpty()) break block3;
                    iterator.remove();
                    break block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(String uri) {
        int count = 0;
        String formatedUri = UriUtils.formatUri((String)uri);
        Map<SnaFilter, List<MidCallback>> map = this.callbacks;
        synchronized (map) {
            for (SnaFilter snaFilter : this.callbacks.keySet()) {
                if (!snaFilter.sender.equals(formatedUri)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(SnaFilter filter) {
        Map<SnaFilter, List<MidCallback>> map = this.callbacks;
        synchronized (map) {
            this.callbacks.remove(filter);
        }
    }

    @Override
    public void handle(SnaMessage<?> message) {
        this.eventEngine.push(message);
    }

    public void doHandle(SnaMessage<?> message) {
        String messageMethod = null;
        block1 : switch (((SnaMessageSubType)((Object)message.getType())).getSnaMessageType()) {
            case RESPONSE: {
                switch ((AccessMethodResponse.Response)message.getType()) {
                    case ACT_RESPONSE: {
                        messageMethod = AccessMethod.ACT;
                        break block1;
                    }
                    case DESCRIBE_RESPONSE: {
                        messageMethod = AccessMethod.DESCRIBE;
                        break block1;
                    }
                    case GET_RESPONSE: {
                        messageMethod = AccessMethod.GET;
                        break block1;
                    }
                    case SET_RESPONSE: {
                        messageMethod = AccessMethod.SET;
                        break block1;
                    }
                    case SUBSCRIBE_RESPONSE: {
                        messageMethod = AccessMethod.SUBSCRIBE;
                        break block1;
                    }
                    case UNSUBSCRIBE_RESPONSE: {
                        messageMethod = AccessMethod.UNSUBSCRIBE;
                        break block1;
                    }
                }
                break;
            }
            case ERROR: 
            case LIFECYCLE: {
                messageMethod = AccessMethod.DESCRIBE;
                break;
            }
            case UPDATE: {
                messageMethod = AccessMethod.GET;
                break;
            }
        }
        try {
            if (messageMethod != null) {
                this.doHandleAgents(message, messageMethod);
            }
            this.doHandleSubscribers(message);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleSubscribers(SnaMessage<?> message) {
        Map<SnaFilter, List<MidCallback>> map = this.callbacks;
        synchronized (map) {
            for (Map.Entry<SnaFilter, List<MidCallback>> entry : this.callbacks.entrySet()) {
                SnaFilter filter = entry.getKey();
                if (!filter.matches(message)) continue;
                Iterator<MidCallback> callbackIterator = entry.getValue().iterator();
                while (callbackIterator.hasNext()) {
                    MidCallback callback = callbackIterator.next();
                    if (callback.getTimeout() != -1L && System.currentTimeMillis() > callback.getTimeout() || !callback.isActive()) {
                        callbackIterator.remove();
                        continue;
                    }
                    callback.getMessageRegisterer().register(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandleAgents(final SnaMessage<?> message, final String method) {
        final String path = message.getPath();
        SnaMessageListener snaMessageListener = this;
        synchronized (snaMessageListener) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SnaMessageListener.this.mediator.callServices(SnaAgent.class, (Executable)new Executable<SnaAgent, Void>(){

                        public Void execute(SnaAgent agent) throws Exception {
                            String agentKey = agent.getPublicKey();
                            List<MethodAccessibility> methodAccessibilities = SnaMessageListener.this.agentsAccessibility.get(agentKey);
                            if (methodAccessibilities == null) {
                                AccessLevelOption option = SnaMessageListener.this.configuration.getAuthenticatedAccessLevelOption(path, agentKey);
                                if (option == null) {
                                    option = AccessLevelOption.ANONYMOUS;
                                }
                                methodAccessibilities = SnaMessageListener.this.configuration.getAccessibleMethods(path, option);
                                SnaMessageListener.this.agentsAccessibility.put(agentKey, methodAccessibilities);
                            }
                            if (methodAccessibilities.stream().filter(ma -> method.equals(ma.getName())).map(MethodAccessibility::isAccessible).findFirst().orElse(false).booleanValue()) {
                                agent.register(message);
                            }
                            return null;
                        }
                    });
                    return null;
                }
            });
        }
    }

    @Override
    public void close(boolean wait) {
        if (wait) {
            super.close();
        } else {
            super.stop();
        }
    }
}

